package com.js.web.service;

import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * @Description: 交易明细查询接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
public interface JsPayTradeService {
    /**
     * @Description: 交易明细列表
     * @Author liuh
     * @Date 2019/6/11
     **/
    ResponseMessage tradeList(JsTradeListReq jsTradeListReq, KycNaturalVO kycNaturalVO);

    /**
     * @Description: 交易详情
     * @Author liuh
     * @Date 2019/6/15
     **/
    ResponseMessage tradeDetail(TradeSubTypeEnum tradeSubTypeEnum,String tradeId);
}
