package com.js.web.service;

import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;

/**
 * @Description: 与寻汇交互服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
public interface JsKycSunrateService {
    /**
     * @Description: 寻汇 -> 合作方 虚拟子账户通知 接口
     * @Author liuh
     * @Date 2019/5/21
     **/
    ResponseMessage virtualNotice(JsPaySunrateBankReq jsPaySunrateBankReq);

    /**
     * @Description: 寻汇 -> 合作方 开户结果通知 接口
     * @Author liuh
     * @Date 2019/5/22
     **/
    ResponseMessage registerCreateNotice(KycSunrateRegisterNoticeReq kycSunrateRegisterNoticeReq);

    /**
     * @Description: 寻汇 -> 合作方 入账通知 接口
     * @Author liuh
     * @Date 2019/6/3
     **/
    ResponseMessage bankTradeInNotice(JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq);

    /**
     * @Description: 寻汇 -> 合作方 审核店铺通知 接口
     * @Author liuh
     * @Date 2019/6/10
     **/
    ResponseMessage storeAuditNotice(SunrateStoreAuditReq sunrateStoreAuditReq);

    /**
     * @Description: 寻汇 -> 合作方 受益人审核结果通知 接口
     * @Author liuh
     * @Date 2019/6/10
     **/
    ResponseMessage beneficiayAuditNotice(SunrateBeneficiaryAuditReq sunrateBeneficiaryAuditReq);

    /**
     * @Description: 出账通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/6/12
     **/
    ResponseMessage bankTradeOutNotice(JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq);
}
