package com.js.web.service;

import com.js.common.enums.SiteEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;

/**
 * @Description: 申请虚拟账户-添加店铺服务接口
 * @Author: liuh
 * @Create: 2019-05-21
 **/
public interface JsKycStoreService {
    /**
     * @Author liuh
     * @Date 2019/5/21
     **/
    ResponseMessage addStore(KycStoreReq kycStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Date 2019/5/23
     **/
    ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取各个站点申请账户数量
     * @Date 2019/5/29
     **/
    ResponseMessage findApplyCountNum(String browserIP,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 根据店铺ID获取店铺及虚拟账户信息
     * @Date 2019/6/19
     **/
    ResponseMessage findStoreDetailInfo(String kycStoreId, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 编辑保存店铺信息
     * @Date 2019/6/25
     **/
    ResponseMessage editStore(KycStoreEditReq kycStoreEditReq, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 获取当前登录用户虚拟账户余额>0的账户列表
     * @Date 2019/6/19
     **/
    ResponseMessage findCanWithdrawStoreList(SiteEnum siteEnum, KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description 申请提现接口数据初始化
     * @Date 2019/6/23
     **/
    ResponseMessage initWithdrawInfo(KycNaturalVO kycNaturalVO);

    /**
     * 校验用户授权店铺的 token 是否有效。
     *
     * @author liutianyu
     * @param kycStoreCheckTokenReq
     * @return
     */
    ResponseMessage checkStoreToken(KycStoreCheckTokenReq kycStoreCheckTokenReq);
}
