package com.js.web.service;

import com.js.common.enums.BankAreaType;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.req.KycBankDeleteReq;
import com.js.common.model.req.KycBankReq;
import com.js.common.model.req.KycCheckBankReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.bind.annotation.RequestBody;

import javax.servlet.http.HttpServletResponse;

/**
 * @Description: kyc_bank交互
 * @Author: liuh
 * @Create: 2019-06-22
 **/
public interface JsKycBankService {
    /**
     * @Author liuh
     * @Description: 获取当前登录用户银行卡列表
     * @Date 2019/6/22
     **/
    ResponseMessage bankList(KycBankCardReq kycBankCardReq,KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description: 添加银行卡初始化数据
     * @Date 2019/6/22
     **/
    ResponseMessage initAddBank(KycNaturalVO kycNaturalVO);

    /**
     * @Author liuh
     * @Description: 根据银行所在地区获取可选择币种列表
     * @Date 2019/6/25
     **/
    ResponseMessage initCurrencyList(BankAreaType bankAra);

    /**
     * @Author liuh
     * @Description: 添加银行卡
     * @Date 2019/6/22
     **/
    ResponseMessage addBankCard(KycBankReq kycBankReq, KycNaturalVO kycNaturalVO, HttpServletResponse response);

    /**
     * 获取银行卡省份信息
     */
    ResponseMessage getProvence();

    /**
     * 获取银行卡市区信息
     */
    ResponseMessage getCity(String provinceCode);

    /**
     * @Author liuh
     * @Description: 删除绑定银行卡
     * @Date 2019/6/26
     **/
    ResponseMessage disableBankCard(KycBankDeleteReq kycBankDeleteReq, KycNaturalVO kycNaturalVO,HttpServletResponse response);

    /**
     * 银行卡二三四要素验证
     * @param kycCheckBankReq
     * @return
     */
    ResponseMessage checkBank(@RequestBody KycCheckBankReq kycCheckBankReq);

    /**
     * @Author liuh
     * @Description: 获取开户行码值列表
     * @Date 2019/6/28
     **/
    ResponseMessage findJsBankList();
}
