package com.js.web.service;

import com.js.common.enums.CertiFileType;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.model.vo.common.ResponseMessage;
import org.springframework.web.multipart.MultipartFile;

import java.io.InputStream;

/**
 * @Author yjzhao
 * @Description js文件服务
 * @Date 2019/5/17 16:48
 * @Param
 * @return
 **/
public interface JsFileSerivce {

    /**
     * @Author yjzhao
     * @Description 上传文件
     * @Date 2019/5/18 20:07
     * @Param file: , fileType, prefix]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage uploadFile(MultipartFile file, FileType fileType, FileResourceType fileResourceType, CertiFileType certiFileType);


    /**
     * @Author yjzhao
     * @Description 根据OSS 文件存储路径删除文件
     * @Date 2019/5/18 20:28
     * @Param [fileUrl]
     * @return com.js.common.model.vo.common.ResponseMessage
     **/
    ResponseMessage  deleteFile(String fileUrl);

    /**
     * @Author yjzhao
     * @Description 根据OSS 文件存储路径获取文件流
     * @Date 2019/5/18 20:28
     * @Param [fileUrl]
     * @return java.io.InputStream
     **/
    InputStream findFile(String fileUrl);
}
