package com.js.web.service;

import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import java.util.Map;

/**
 * 汇付国际回调
 * zhouyongsheng
 */
public interface ChinapnrPaySerivce {

    /**
     * 提现代发
     * @param chinaPNRSubstituteReq
     * @return
     * @throws Exception
     */
    ResponseMessage substituteNew(ChinaPNRSubstituteReq chinaPNRSubstituteReq);

    /**
     * 还款汇差服务费代发
     * @param chinaPNRSubstituteReq
     * @return
     * @throws Exception
     */
    ResponseMessage substituteOld(ChinaPNRSubstituteReq chinaPNRSubstituteReq) ;


    /**
     * 个人开户
     * @param chinaPNRPersonalOpenAccountReq
     * @return
     * @throws Exception
     */
    ResponseMessage opendAccountPersonal(ChinaPNRPersonalOpenAccountReq chinaPNRPersonalOpenAccountReq);


    /**
     * 企业开户
     * @param chinaPNREnterpriseOpenAccountReq
     * @return
     * @throws Exception
     */
    ResponseMessage opendAccountEnterprise(ChinaPNREnterpriseOpenAccountReq chinaPNREnterpriseOpenAccountReq) ;


    /**
     * 客户提现查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    ResponseMessage queryNewSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq);

    /**
     * 客户还款，还款服务费,汇差 ，提现服务费交易查询
     * @param chinaPNRSubstituteQueryReq
     * @return
     */
    ResponseMessage queryOldSubstitute(ChinaPNRSubstituteQueryReq chinaPNRSubstituteQueryReq);

    /**
     * 个人开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    ResponseMessage personalUpdateOpenAccount(ChinaPNRPersonalOpenAccountReq chinaPNROpenAccountReq);

    /**
     * 企业开户信息修改
     * @param chinaPNROpenAccountReq
     * @return
     */
    ResponseMessage enterpriseUpdateOpenAccount(ChinaPNREnterpriseOpenAccountReq chinaPNROpenAccountReq);

    /**
     * 个人开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    ResponseMessage personalQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq);

    /**
     * 企业开户信息查询
     * @param chinaPNRQueryOpenAccountReq
     * @return
     */
    ResponseMessage enterpriseQueryOpenAccount(ChinaPNRQueryOpenAccountReq chinaPNRQueryOpenAccountReq);

}
