package com.js.web.properties;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 验证码配置
 */
@Data
@ConfigurationProperties(prefix = "jsweb.validate.code")
@Component("validateCodeProperties")
public class ValidateCodeProperties {
    /**
     * 图片验证码配置
     */
    private ImageCodeProperties image = new ImageCodeProperties();

    /**
     * 短信验证码配置
     */
    private SmsCodeProperties sms = new SmsCodeProperties();

    /**
     * 短信验证码配置
     */
    private EmailCodeProperties email = new EmailCodeProperties();

    @Data
    public class EmailCodeProperties {
        /**
         * 验证码长度
         */
        private int length = 6;
        /**
         * 过期时间
         */
        private int expireIn = 60;
        /**
         * 要拦截的url，多个url用逗号隔开，ant pattern
         */
        private String url;
    }

    @Data
    public class SmsCodeProperties {
        /**
         * 验证码长度
         */
        private int length = 6;
        /**
         * 过期时间
         */
        private int expireIn = 60;
        /**
         * 要拦截的url，多个url用逗号隔开，ant pattern
         */
        private String url;
    }

    @Data
    public class ImageCodeProperties extends SmsCodeProperties {
        public ImageCodeProperties() {
            setLength(4);
        }

        /**
         * 图片宽
         */
        private int width = 127;
        /**
         * 图片高
         */
        private int height = 40;

        /**
         * 要拦截的url，多个url用逗号隔开，ant pattern
         */
        private String url;

        /**
         * 过期时间
         */
        private int expireIn = 60;
    }
}
