package com.js.web.controller.web;

import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Optional;

/**
 * @Author liuh
 * @Description natural表交互
 * @Date 2019/6/24
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class KycNautralController {

    @Autowired
    private JsKycNaturalService jsKycNaturalService;

    /**
     * 通过数据库查找当前登录用户信息
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/kycNatural/findNaturalInfo")
    public ResponseMessage findNaturalInfo(HttpServletRequest request,HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> kycNaturalVOByWebToken = jsKycNaturalService.findKycNaturalVOByWebToken(request, response);
        KycNaturalVO kycNaturalVO = jsKycNaturalService.findKycNaturalVO(kycNaturalVOByWebToken.get());
        return null == kycNaturalVO ? ResultUtil.error(ResultEnum.USER_NOT_EXIST) : ResultUtil.success(kycNaturalVO);
    }

}
