package com.js.web.controller.web;

import cn.hutool.core.lang.Console;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiFileType;
import com.js.common.enums.FileResourceType;
import com.js.common.enums.FileType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.web.service.JsFileSerivce;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @Author yjzhao
 * @Description 文件操作
 * @Date 2019/5/18 20:36
 * @Param 
 * @return 
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsFileController {

    @Autowired
    private JsFileSerivce jsFileSerivce;


    /**
     * 上传文件
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsFile/upFile")
    public ResponseMessage upFileTest(MultipartFile file,
                                      FileType fileType,
                                      FileResourceType fileResourceType, CertiFileType certiFileType) {
        return jsFileSerivce.uploadFile(file, fileType, fileResourceType,certiFileType);
    }

    /**
     * 删除文件
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsFile/delFile")
    public ResponseMessage delFile(String filePath) {

        return jsFileSerivce.deleteFile(filePath);
    }

    /**
     * 下载文件
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsFile/downLoad")
    public ResponseMessage downLoad(String filePath,
                                    String fileName,
                                    HttpServletResponse response) {
        try(InputStream inputStream =  jsFileSerivce.findFile(filePath);
                OutputStream outputStream = response.getOutputStream();){
                response.setContentType("application/x-download");
                response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
                IOUtils.copy(inputStream, outputStream);
                outputStream.flush();
        }catch (IOException e){
            Console.log(e);
            return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_ERROR.getCode(), ResultEnum.FILE_DOWNLOAD_ERROR.getMsg());

        }
        return ResultUtil.success(ResultEnum.FILE_DOWNLOAD_SUCCESS.getCode(), ResultEnum.FILE_DOWNLOAD_SUCCESS.getMsg());
    }
}
