package com.js.web.controller.vat;

import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.JsPayVatPaymentInfoReq;
import com.js.common.model.req.JsPayVatPaymentRcvListReq;
import com.js.common.model.req.KycShowStoreReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;
import com.js.web.service.JsPayVatPaymentInfoService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
@Slf4j
public class JsPayVatPaymentController {

    @Autowired
    private JsPayVatPaymentInfoService jsPayVatPaymentInfoService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    /**
     * vat 缴税收款人列表
     * @Author liwm
     * @Date 2019/6/27
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/queryRcvList")
    public ResponseMessage queryRcvList(@Valid @RequestBody JsPayVatPaymentRcvListReq jsPayVatPaymentRcvListReq) throws Exception{
        return  jsPayVatPaymentInfoService.queryRcvList(jsPayVatPaymentRcvListReq);
    }

    /**
     * vat 缴税 提交
     * @Author liwm
     * @Date 2019/6/28
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsVatPayment/payVatPayment")
    public ResponseMessage payVatPayment(@Valid @RequestBody JsPayVatPaymentInfoReq jsPayVatPaymentInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return  jsPayVatPaymentInfoService.payVatPayment(jsPayVatPaymentInfoReq,optionalKycNaturalVO.get().getRegisterType());
    }


}
