package com.js.web.controller.swagger;

import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanApplyInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsLoanApplicationService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;

@Api(value="贷款申请",tags="贷款申请")
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsLoanApplicationSwaggerController {

    @Autowired
    private JsLoanApplicationService jsLoanApplicationService;

    /**
     * 贷款申请
     * @return
     */
    @ApiOperation(value="贷款申请",notes="贷款申请")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/loan/apply",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage loanApply(@Valid @RequestBody JsLoanApplyInfoReq jsLoanApplyInfoReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        return jsLoanApplicationService.loanApply(jsLoanApplyInfoReq);
    }
}
