package com.js.web.controller.pay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.common.JsException.LogicException;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.model.vo.common.SunrateResponseMessage;
import com.js.web.service.JsKycSunrateService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 * @Author liuh
 * @Description 与寻汇调用前后端交互controller
 * @Date 2019/5/21
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_FORM_URLENCODED_VALUE})
@Slf4j
public class JsSunrateController {
    @Autowired
    JsKycSunrateService jsKycSunrateService;

    /**
     * 结果通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/6/25
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/notice")
    public SunrateResponseMessage sunrateNotice(@Valid @ModelAttribute SunrateNoticeReq sunrateNoticeReq){
        log.info("寻汇通知入参：{}",sunrateNoticeReq);
        String apiUser = sunrateNoticeReq.getApiUser();
        String methodName = sunrateNoticeReq.getMethod();
        Object object = sunrateNoticeReq.getReqBody();
        JSONObject jsonObject = JSONObject.parseObject(object.toString());
        SunrateResponseMessage sunrateResponseMessage = new SunrateResponseMessage();
        ResponseMessage responseMessage;
        try {
            if ("register.result".equals(methodName)) {
                //3.2开户结果通知（寻汇 -> 合作方）
                responseMessage = jsKycSunrateService.registerCreateNotice(jsonObject.toJavaObject(KycSunrateRegisterNoticeReq.class));
            } else if ("beneficiary.result".equals(methodName)) {
                //4.3审核受益人结果通知（寻汇 -> 合作方）
                responseMessage = jsKycSunrateService.beneficiayAuditNotice(jsonObject.toJavaObject(SunrateBeneficiaryAuditReq.class));
            } else if ("amazon.store.result".equals(methodName)) {
                //5.4审核店铺通知（寻汇 -> 合作方）
                responseMessage = jsKycSunrateService.storeAuditNotice(jsonObject.toJavaObject(SunrateStoreAuditReq.class));
            } else if ("acct.virtAcct.result".equals(methodName)) {
                //7.1虚拟子账户通知（寻汇 -> 合作方）
                responseMessage = jsKycSunrateService.virtualNotice(jsonObject.toJavaObject(JsPaySunrateBankReq.class));
            } else if ("fund.transin.result".equals(methodName)) {
                //9.1入账通知（寻汇 -> 合作方）
                responseMessage = jsKycSunrateService.bankTradeInNotice(jsonObject.toJavaObject(JsPaySunrateBankTradeInReq.class));
            } else if ("fund.transout.result".equals(methodName)) {
                //9.3出账通知（寻汇 -> 合作方）
                responseMessage = jsKycSunrateService.bankTradeOutNotice(jsonObject.toJavaObject(JsPaySunrateBankTradeOutReq.class));
            } else {
                sunrateResponseMessage.setRspCode(ResultEnum.NO_MUST_PARAM_ERROR.getCode().toString());
                sunrateResponseMessage.setRspInfo(ResultEnum.NO_MUST_PARAM_ERROR.getMsg());
                return sunrateResponseMessage;
            }
        }catch (LogicException e){
            log.error("寻汇通知異常",e);
            sunrateResponseMessage.setRspCode(ResultEnum.NO_MUST_PARAM_ERROR.getCode().toString());
            sunrateResponseMessage.setRspInfo(e.getErrorMsg());
            return sunrateResponseMessage;
        }
        if(responseMessage.isSuccess()){
            sunrateResponseMessage.setRspCode("000000");
            sunrateResponseMessage.setRspInfo("通知成功");
        }else{
            sunrateResponseMessage.setRspCode(String.valueOf(responseMessage.getCode()));
            sunrateResponseMessage.setRspInfo(responseMessage.getMsg());
        }
        log.info("{}方法通知結果:{}",methodName,JSON.toJSONString(sunrateResponseMessage));
        return sunrateResponseMessage;
    }

    /**
     * 3.2开户结果通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/5/30
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/registerCreateNotice")
    public ResponseMessage registerCreateNotice(@Valid @ModelAttribute KycSunrateRegisterNoticeReq kycSunrateRegisterNoticeReq){
        return jsKycSunrateService.registerCreateNotice(kycSunrateRegisterNoticeReq);
    }

    /**
     * 4.3审核受益人结果通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/6/10
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/beneficiayAuditNotice")
    public ResponseMessage beneficiayAuditNotice(@Valid @ModelAttribute SunrateBeneficiaryAuditReq sunrateStoreAuditReq){
        return jsKycSunrateService.beneficiayAuditNotice(sunrateStoreAuditReq);
    }

    /**
     * 5.4审核店铺通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/6/10
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/storeAuditNotice")
    public ResponseMessage storeAuditNotice(@Valid @ModelAttribute SunrateStoreAuditReq sunrateStoreAuditReq){
        return jsKycSunrateService.storeAuditNotice(sunrateStoreAuditReq);
    }

    /**
     * 7.1虚拟子账户通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/5/30
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/virtualNotice")
    public ResponseMessage virtualNotice(@Valid @ModelAttribute JsPaySunrateBankReq jsPaySunrateBankReq){
        return jsKycSunrateService.virtualNotice(jsPaySunrateBankReq);
    }

    /**
     * 9.1入账通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/6/03
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/bankTradeInNotice")
    public ResponseMessage bankTradeInNotice(@Valid @ModelAttribute JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq){
        return jsKycSunrateService.bankTradeInNotice(jsPaySunrateBankTradeInReq);
    }

    /**
     * 9.3出账通知（寻汇 -> 合作方）
     * @Author liuh
     * @Date 2019/6/11
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/bankTradeOutNotice")
    public ResponseMessage bankTradeOutNotice(@Valid @ModelAttribute JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq){
        return jsKycSunrateService.bankTradeOutNotice(jsPaySunrateBankTradeOutReq);
    }

    /**
     * 9.4 批次出账通知（寻汇 -> 合作方）
     * @Author liuh      // TODO 暂不实现
     * @Date 2019/6/12
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/sunrate/bankTradeOutBatchNotice")
    public ResponseMessage bankTradeOutBatchNotice(@Valid @ModelAttribute JsPaySunrateBankTradeOutReq jsPaySunrateBankTradeOutReq){
        return jsKycSunrateService.bankTradeOutNotice(jsPaySunrateBankTradeOutReq);
    }
}
