package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsKycStoreService;
import com.js.web.service.JsPaySunrateBankService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 虚拟账户-js店铺前后端交互controller
 * @Date 2019/5/21
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsStoreController {
    @Autowired
    private JsKycStoreService jsKycStoreService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;
    @Autowired
    JsPaySunrateBankService jsPaySunrateBankService;

    /**
     * 申请虚拟账户-添加店铺操作
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/addStore",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage addStore(@Valid @RequestBody KycStoreReq kycStoreReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.addStore(kycStoreReq,optionalKycNaturalVO.get());
    }

    /**
     * js我的店铺列表
     * @Author liuh
     * @Date 2019/5/23
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/storeList")
    public ResponseMessage storeList(KycShowStoreReq kycShowStoreReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.storeList(kycShowStoreReq,optionalKycNaturalVO.get());
    }

    /**
     * 获取当前用户各个站点申请账户数量，及时时汇率信息
     * @Author liuh
     * @Date 2019/5/29
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/findApplyCountNum")
    public ResponseMessage findApplyCountNum(@RequestParam String browserIP, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.findApplyCountNum(browserIP,optionalKycNaturalVO.get());
    }

    /**
     * 根据店铺ID获取店铺及虚拟账户信息
     * @Author liuh
     * @Date 2019/6/19
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/findStoreDetailInfo")
    public ResponseMessage findStoreDetailInfo(@RequestParam String kycStoreId, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.findStoreDetailInfo(kycStoreId,optionalKycNaturalVO.get());
    }

    /**
     * 编辑保存店铺信息
     * @Author liuh
     * @Date 2019/6/25
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/editStore",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage editStore(@Valid @RequestBody KycStoreEditReq kycStoreEditReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.editStore(kycStoreEditReq,optionalKycNaturalVO.get());
    }

    /**
     * 获取当前登录用户虚拟账户余额>0的账户列表
     * @Author liuh
     * @Date 2019/6/19
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/findCanWithdrawStoreList")
    public ResponseMessage findCanWithdrawStoreList(@RequestParam SiteEnum siteCode, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.findCanWithdrawStoreList(siteCode,optionalKycNaturalVO.get());
    }

    /**
     * 申请提现接口数据初始化
     * @Author liuh
     * @Date 2019/6/23
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/initWithdrawInfo")
    public ResponseMessage initWithdrawInfo(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycStoreService.initWithdrawInfo(optionalKycNaturalVO.get());
    }

    /**
     * 申请提现接口
     * @Author liuh
     * @Date 2019/6/26
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/applyWithdraw",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage applyWithdraw(@Valid @RequestBody ApplyWithdrawTotalReq applyWithdrawTotalReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPaySunrateBankService.applyWithdraw(applyWithdrawTotalReq,optionalKycNaturalVO.get(),response);
    }

    /**
     * 店铺 token 校验
     * @author liutianyu
     * @date 2019/6/26
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsStore/checkStoreToken")
    public ResponseMessage checkStoreToken(@Valid @RequestBody KycStoreCheckTokenReq kycStoreCheckTokenReq){
        return jsKycStoreService.checkStoreToken(kycStoreCheckTokenReq);
    }
}
