package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.enums.TradeSubTypeEnum;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycNaturalService;
import com.js.web.service.JsPayTradeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 交易操作前后端交互controller
 * @Date 2019/6/6
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsPayTradeController {
    @Autowired
    JsPayTradeService jsPayTradeService;
    @Autowired
    private JsKycNaturalService jsKycNaturalService;

    /**
     * 查询交易明细列表
     * @Author liuh
     * @Date 2019/6/6
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/payTrade/tradeList")
    public ResponseMessage tradeList(@Valid JsTradeListReq jsTradeListReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsPayTradeService.tradeList(jsTradeListReq,optionalKycNaturalVO.get());
    }

    /**
     * 交易详情
     * @Author liuh
     * @Date 2019/6/15
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/payTrade/tradeDetail")
    public ResponseMessage tradeDetail(@RequestParam TradeSubTypeEnum tradeSubTypeEnum,@RequestParam String tradeId) throws Exception{
        return jsPayTradeService.tradeDetail(tradeSubTypeEnum,tradeId);
    }
}
