package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.enums.BankAreaType;
import com.js.common.model.req.KycBankCardReq;
import com.js.common.model.req.KycBankDeleteReq;
import com.js.common.model.req.KycBankReq;
import com.js.common.model.req.KycCheckBankReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycBankService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 提现银行交互controller
 * @Date 2019/6/22
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class JsKycBankController {
    @Autowired
    JsKycBankService jsKycBankService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 获取当前登录用户银行卡列表
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/bankList")
    public ResponseMessage bankList(KycBankCardReq kycBankCardReq , HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycBankService.bankList(kycBankCardReq,optionalKycNaturalVO.get());
    }

    /**
     * 添加银行卡初始化数据 1)
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/initAddBank")
    public ResponseMessage initAddBank(HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycBankService.initAddBank(optionalKycNaturalVO.get());
    }

    /**
     * 添加银行卡初始化数据 2) 根据选择地区返回可选择币种信息
     * @Author liuh
     * @Date 2019/6/25
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/initCurrencyList")
    public ResponseMessage initCurrencyList(@RequestParam BankAreaType bankAra){
        return jsKycBankService.initCurrencyList(bankAra);
    }

    /**
     * 获取开户银行码值
     * @Author liuh
     * @Date 2019/6/28
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsBank/findJsBankList")
    public ResponseMessage findJsBankList(){
        return jsKycBankService.findJsBankList();
    }

    /**
     * 删除绑定银行卡
     * @Author liuh
     * @Date 2019/6/26
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/disableBankCard",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage disableBankCard(@Valid @RequestBody KycBankDeleteReq kycBankDeleteReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycBankService.disableBankCard(kycBankDeleteReq,optionalKycNaturalVO.get(),response);
    }

    /**
     * 添加银行卡
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/addBankCard",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage addBankCard(@Valid @RequestBody KycBankReq kycBankReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        return jsKycBankService.addBankCard(kycBankReq,optionalKycNaturalVO.get(),response);
    }

    /**
     * 获取省份
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/getProvence")
    public ResponseMessage getProvence() {
        return jsKycBankService.getProvence();
    }

    /**
     * 获取市区
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/getCity")
    public ResponseMessage getCity(String provinceCode) {
        return jsKycBankService.getCity(provinceCode);
    }

    /**
     * 校验银行二三四要素
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/jsKycBank/checkBank",consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage checkBank(@Valid @RequestBody KycCheckBankReq kycCheckBankReq) {
        return jsKycBankService.checkBank(kycCheckBankReq);
    }

}
