package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycDictionaryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * @Author liuh
 * @Description 字典表前后端交互controller
 * @Date 2019/5/18
 * @Param
 * @return
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class DictionaryController {

    @Autowired
    private JsKycDictionaryService jsKycDictionaryService;

    /**
     * 根据类型查找字典表对应信息列表
     * @param type  字典类型
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/dictionary/findDictionary")
    public ResponseMessage findDictionary(@RequestParam(value = "type",required = false) String type, @RequestParam(value = "code",required = false) String code) {
        return jsKycDictionaryService.findDictionary(type,code);
    }
}
