package com.js.web.controller.pay;

import com.js.common.constant.Constant;
import com.js.common.model.req.KycCertiHKPersonalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.JsKycCertiHKPersonalService;
import com.js.web.service.JsKycNaturalService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import java.util.Optional;

/**
 * @Author liuh
 * @Description 香港个人前后端交互controller
 * @Date 2019/6/1
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class CertiHKPersonalController {

    @Autowired
    private JsKycCertiHKPersonalService jsKycCertiHKPersonalService;
    @Autowired
    JsKycNaturalService jsKycNaturalService;

    /**
     * 实名认证-大香港个人保存接口
     * @return
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/certiHK/addPersonal",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public ResponseMessage certiHKPersonalAdd(@Valid @RequestBody KycCertiHKPersonalReq kycCertiHKPersonalReq, HttpServletRequest request, HttpServletResponse response) throws Exception{
        Optional<KycNaturalVO> optionalKycNaturalVO = jsKycNaturalService.findKycNaturalVOByWebToken(request,response);
        ResponseMessage responseMessage = jsKycCertiHKPersonalService.certiHKPersonalAdd(kycCertiHKPersonalReq,optionalKycNaturalVO.get());
        return responseMessage;
    }
}
