package com.js.web.controller.loan;


import com.js.common.constant.Constant;
import com.js.common.model.req.JsLoanStatisticsInfoReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.StatisticsInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 向借贷系统提供用户相关信息
 *
 * @author EDZ
 */
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE},
        consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class StatisticsInfoController {

    @Autowired
    StatisticsInfoService statisticsInfoService;

    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/kyc")
    public ResponseMessage getPlatformKycInfo(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq){
        return statisticsInfoService.getPlatformKycInfo(jsLoanStatisticsInfoReq);
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/storeList")
    public ResponseMessage getPlatformStoreInfoList(@RequestBody JsLoanStatisticsInfoReq jsLoanStatisticsInfoReq){
        return statisticsInfoService.getPlatformStoreInfoList(jsLoanStatisticsInfoReq);
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/statisticsInfo/platform/statistics/{kycNaturalId}")
    public ResponseMessage getPlatformStatisticsInfo(@PathVariable("kycNaturalId") String kycNaturalId){
        return statisticsInfoService.getPlatformStatisticsInfo(kycNaturalId);
    }
}
