package com.js.web.controller.chinapnr;


import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.web.service.ChinapnrCallbackSerivce;
import com.js.web.utils.ServletUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;


/**
 * 汇付国际支付接口回调
 */
@Api("汇付国际支付回调")
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
public class ChinapnrCallbackController {

    @Autowired
    private ChinapnrCallbackSerivce chinapnrCallbackSerivce;


    private static String RESP_MSG ="<result>1</result>";
    private static String ERROR ="ERROR";

    /**
     * 汇付国际提现服务代发回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际新版本代发回调",notes="汇付国际新版本代发回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/substitute/newCallback",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public String substituteNewCallback(HttpServletRequest request){

        Map<String,String> map = ServletUtils.getRequestParameters(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.substituteNewCallback(map);
        if(responseMessage.getCode() == ResultEnum.CHINA_PNR_SUCCESS.getCode()){
            return RESP_MSG;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付国际还款汇差服务费代发回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际还款汇差服务费代发回调",notes="汇付国际还款汇差服务费代发回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/substitute/oldCallback",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public String substituteOldCallback(HttpServletRequest request){
        //Map<String,String> map = ServletUtils.getRequestParameters(request);
        String resXml = ServletUtils.recieveData(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.substituteOldCallback(resXml);
        if(responseMessage.getCode() == ResultEnum.CHINA_PNR_SUCCESS.getCode()){
            String resMsg = responseMessage.getData().toString(); //返回结果消息
            return resMsg;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付国际个人用户开户回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际个人用户开户回调",notes="汇付国际个人用户开户回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/opendAccount/personal",
            consumes = {MediaType.TEXT_PLAIN_VALUE})
    public String opendAccountPersonal(HttpServletRequest request){
        //Map<String,String> map = ServletUtils.getRequestParameters(request);
        String resText = ServletUtils.fetchPostByTextPlain(request);
        Map<String,String> map = ServletUtils.getCallbackMap(resText);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.opendAccountPersonal(map);
        if(responseMessage.getCode() == ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS.getCode()){
            return RESP_MSG;
        }else{
            return ERROR;
        }
    }

    /**
     * 汇付国际企业用户开户回调
     * @param request
     * @return
     * @throws Exception
     */
    @ApiOperation(value="汇付国际企业用户开户回调",notes="汇付国际企业用户开户回调")
    @PostMapping(value = Constant.ApiLoginAuth.ANON +"/opendAccount/enterprise",
            consumes = {MediaType.APPLICATION_JSON_UTF8_VALUE})
    public String opendAccountEnterprise(HttpServletRequest request){
        Map<String,String> map = ServletUtils.getRequestParameters(request);
        ResponseMessage responseMessage = chinapnrCallbackSerivce.opendAccountEnterprise(map);
        if(responseMessage.getCode() == ResultEnum.CHINA_PNR_OPEND_ACCOUNT_SUCCESS.getCode()){
            return RESP_MSG;
        }else{
            return ERROR;
        }
    }
}
