package com.js.manage.util;

import com.js.manage.service.system.menu.impl.MenuService;
import com.js.manage.service.system.role.impl.RoleService;
import com.js.manage.service.system.user.UserManager;


/**
 * 说明：获取Spring容器中的service bean
 * 作者：FH Admin QQ313596790
 * 官网：www.fhadmin.org
 */
public final class ServiceHelper {
	
	public static Object getService(String serviceName){
		//WebApplicationContextUtils.
		return Const.WEB_APP_CONTEXT.getBean(serviceName);
	}
	
	public static UserManager getUserService(){
		return (UserManager) getService("userService");
	}
	
	public static RoleService getRoleService(){
		return (RoleService) getService("roleService");
	}
	
	public static MenuService getMenuService(){
		return (MenuService) getService("menuService");
	}
}
