package com.js.manage.util;

import cn.hutool.core.date.DateUtil;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class BeanUtil {

    public static Map<String, Object> beanToMap(Object bean) {
        Map<String, Object> map = cn.hutool.core.bean.BeanUtil.beanToMap(bean);
        map.entrySet().stream().forEach(e -> {
            if (e.getValue() instanceof Date) {
                e.setValue(DateUtil.format((Date) e.getValue(), "yyyy-MM-dd"));
            }
        });
        return map;
    }

    public static List<Map<String, Object>> listBeanToMap(List beanList) {
        List<Map<String, Object>> list = new ArrayList<>();
        for (Object o : beanList) {
            list.add(beanToMap(o));
        }
        return list;
    }

}
