package com.js.manage.controller.system.createcode;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.hutool.core.util.StrUtil;
import com.js.manage.properties.JsReverseProperties;
import com.js.manage.util.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.js.manage.controller.base.BaseController;

/**
 * 说明：反向生成
 * 作者：FH Admin Q313596790
 * 官网：www.fhadmin.org
 */
@Controller
@RequestMapping(value="/recreateCode")
public class ReverseCreateCodeController extends BaseController {
	
	String menuUrl = "recreateCode/list.do"; //菜单地址(权限用)
	@Autowired
	JsReverseProperties jsReverseProperties;

	/**列表
	 * @return
	 */
	@RequestMapping(value="/list")
	public ModelAndView list() throws Exception{
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "cha")){} 	//校验权限
		ModelAndView mv = this.getModelAndView();
		mv.setViewName("system/createcode/recreatecode_list");
		mv.addObject("pd", BeanUtil.beanToMap(jsReverseProperties));	//按钮权限
		mv.addObject("QX",Jurisdiction.getHC());	//按钮权限
		return mv;
	}
	
	 /**列出所有表
	 * @param
	 * @throws Exception
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping(value="/listAllTable")
	@ResponseBody
	public Object listAllTable(){
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "cha")){return null;} //校验权限
		PageData pd = new PageData();		
		pd = this.getPageData();
		Map<String,Object> map = new HashMap<String,Object>();
		List<PageData> pdList = new ArrayList<PageData>();
		List<String> tblist = new ArrayList<String>();
		try {
			Object[] arrOb = DbFH.getTables(pd);
			tblist = (List<String>)arrOb[1];
			pd.put("msg", "ok");
		} catch (ClassNotFoundException e) {
			pd.put("msg", "no");
			e.printStackTrace();
		} catch (SQLException e) {
			pd.put("msg", "no");
			e.printStackTrace();
		}
		pdList.add(pd);
		map.put("tblist", tblist);
		map.put("list", pdList);
		return AppUtil.returnObject(pd, map);
	}
	
	/**去代码生成器页面(进入弹窗)
	 * @return
	 * @throws Exception
	 */
	@RequestMapping(value="/goProductCode")
	public ModelAndView goProductCode() throws Exception{
		ModelAndView mv = this.getModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		// 自动生成一个类名
        String tableName = pd.getString("table");
        String className = "";
        String[] strs = tableName.split("_");
        for (String str : strs) {
            className += StrUtil.upperFirst(str);
        }
        pd.put("className", className);
        String fieldType = "";
		StringBuffer sb = new StringBuffer("");
		List<Map<String,String>> columnList = DbFH.getFieldParameterLsit(DbFH.getFHCon(pd),pd.getString("table"),pd.getString("dbtype")); //读取字段信息
		for(int i=0;i<columnList.size();i++){
			Map<String,String> fmap = columnList.get(i);
			if ("id".equals(fmap.get("fieldNanme").toString().toLowerCase())) {
				// 自动跳过主键
				continue;
			}
			sb.append(fmap.get("fieldNanme").toString().toLowerCase());					//字段名称
			sb.append(",fh,");
			fieldType = fmap.get("fieldType").toString().toLowerCase();					//字段类型
			if ("tinyint".equals(fieldType) && "1".equals(fmap.get("fieldLength"))) {
				sb.append("Boolean");
			} else if ("decimal".equals(fieldType)) {
				sb.append("BigDecimal");
			} else if (fieldType.contains("int")) {
				sb.append("Integer");
			} else if (fieldType.contains("number")) {
				if (Integer.parseInt(fmap.get("fieldSccle")) > 0) {
					sb.append("Double");
				} else {
					sb.append("Integer");
				}
			} else if (fieldType.contains("double") || fieldType.contains("numeric")) {
				sb.append("Double");
			} else if (fieldType.contains("date")) {
				sb.append("Date");
			} else {
				sb.append("String");
			}
			sb.append(",fh,");
			if("".equals(fmap.get("fieldComment").toString())){
				sb.append("备注"+(i+1));													//当字段没有注释的时候用'备注'代替
			}else{
				sb.append(fmap.get("fieldComment").toString());							//字段注释
			}
			sb.append(",fh,");
			sb.append("是");																//是否前台录入
			sb.append(",fh,");
			sb.append("无");																//默认值
			sb.append(",fh,");
			sb.append(fmap.get("fieldLength").toString());								//长度
			sb.append(",fh,");
			sb.append(fmap.get("fieldSccle").toString());								//小数点右边的位数
			sb.append(",fh,");
			String camelCase = StrUtil.toCamelCase(fmap.get("fieldNanme").toString().toUpperCase());
			if (!fmap.get("fieldNanme").toString().contains("_")) {
				camelCase = camelCase.toLowerCase();
			}
			sb.append(camelCase);	// 驼峰命名
			sb.append(",fh,");
			sb.append("null");		
			sb.append("Q313596790");
		}
		pd.put("FIELDLIST", sb.toString());
		mv.addObject("msg", "edit");
		mv.addObject("pd", pd);
		mv.setViewName("system/createcode/reProductCode");
		return mv;
	}
	
}