package com.js.manage.controller.pay.kycstore;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import com.js.api.jspay.service.ApiKycStoreService;
import com.js.common.constant.Constant;
import com.js.common.model.vo.KycStoreVO;
import com.js.dal.dao.mapper.KycStoreMapper;
import com.js.dal.dao.mapper.QichachaFullDetailsMapper;
import com.js.dal.dao.model.KycStore;
import com.js.dal.dao.model.QichachaFullDetails;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.js.manage.controller.base.BaseController;
import com.js.manage.entity.Page;
import com.js.manage.util.AppUtil;
import com.js.manage.util.ObjectExcelView;
import com.js.manage.util.PageData;
import com.js.manage.util.Jurisdiction;
import com.js.manage.util.Tools;
import com.js.manage.service.pay.kycstore.KycStoreManager;
import tk.mybatis.mapper.entity.Example;

/** 
 * 说明：平台店铺
 * 创建人：FH Q313596790
 * 创建时间：2019-08-28
 */
@Slf4j
@Controller
@RequestMapping(value="/kycstore")
public class KycStoreController extends BaseController {
	
	String menuUrl = "kycstore/list.do"; //菜单地址(权限用)
	@Resource(name="kycstoreService")
	private KycStoreManager kycstoreService;

	@Reference(
			protocol = "dubbo",
			version = Constant.DUBBO_VERSION,
			application = "jsmanage-consumer-web",
			registry = "jsweb-registry-1",
			timeout = 60000,
			retries = 0
	)
	ApiKycStoreService apiKycStoreService;

	@Autowired
	KycStoreMapper kycStoreMapper;
	@Autowired
	QichachaFullDetailsMapper qichachaFullDetailsMapper;
	
	/**保存
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/save")
	public ModelAndView save() throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"新增KycStore");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "add")){return null;} //校验权限
		ModelAndView mv = this.getModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		pd.put("ID", this.get32UUID());	//主键
		kycstoreService.save(pd);
		mv.addObject("msg","success");
		mv.setViewName("save_result");
		return mv;
	}
	
	/**删除
	 * @param out
	 * @throws Exception
	 */
	@RequestMapping(value="/delete")
	public void delete(PrintWriter out) throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"删除KycStore");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "del")){return;} //校验权限
		PageData pd = new PageData();
		pd = this.getPageData();
		kycstoreService.delete(pd);
		out.write("success");
		out.close();
	}
	
	/**修改
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/edit")
	public ModelAndView edit() throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"修改KycStore");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "edit")){return null;} //校验权限
		ModelAndView mv = this.getModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		kycstoreService.edit(pd);
		mv.addObject("msg","success");
		mv.setViewName("save_result");
		return mv;
	}
	
	/**列表
	 * @param page
	 * @throws Exception
	 */
	@RequestMapping(value="/list")
	public ModelAndView list(Page page) throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"列表KycStore");
		//if(!Jurisdiction.buttonJurisdiction(menuUrl, "cha")){return null;} //校验权限(无权查看时页面会有提示,如果不注释掉这句代码就无法进入列表页面,所以根据情况是否加入本句代码)
		ModelAndView mv = this.getModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		String keywords = pd.getString("keywords");				//关键词检索条件
		if(null != keywords && !"".equals(keywords)){
			pd.put("keywords", keywords.trim());
		}
		// TODO 测试用，稳定之后需要删除掉 by liuty
//		KycStoreVO vo = apiKycStoreService.findKycStoreByPrimaryKey("0e4c52e23a2548878faad7ed80179c1b", null);
//		log.info("dfsdfsf {}", vo);
//		List<KycStore> kycStores = kycStoreMapper.selectAll();
		List<QichachaFullDetails> qichachaFullDetails = qichachaFullDetailsMapper.selectByExample(new Example(QichachaFullDetails.class));
//		log.info("试试数据源是不是可以成功运行 {}", kycStores);
//		log.info("试试数据源是不是可以成功运行 {}", kycStores);
		log.info("试试数据源是不是可以成功运行 {}", qichachaFullDetails);
		page.setPd(pd);
		List<PageData>	varList = kycstoreService.list(page);	//列出KycStore列表
		mv.setViewName("pay/kycstore/kycstore_list");
		mv.addObject("varList", varList);
		mv.addObject("pd", pd);
		mv.addObject("QX",Jurisdiction.getHC());	//按钮权限
		return mv;
	}
	
	/**去新增页面
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/goAdd")
	public ModelAndView goAdd()throws Exception{
		ModelAndView mv = this.getModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		mv.setViewName("pay/kycstore/kycstore_edit");
		mv.addObject("msg", "save");
		mv.addObject("pd", pd);
		return mv;
	}	
	
	 /**去修改页面
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/goEdit")
	public ModelAndView goEdit()throws Exception{
		ModelAndView mv = this.getModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		pd = kycstoreService.findById(pd);	//根据ID读取
		mv.setViewName("pay/kycstore/kycstore_edit");
		mv.addObject("msg", "edit");
		mv.addObject("pd", pd);
		return mv;
	}	
	
	 /**批量删除
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/deleteAll")
	@ResponseBody
	public Object deleteAll() throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"批量删除KycStore");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "del")){return null;} //校验权限
		PageData pd = new PageData();		
		Map<String,Object> map = new HashMap<String,Object>();
		pd = this.getPageData();
		List<PageData> pdList = new ArrayList<PageData>();
		String DATA_IDS = pd.getString("DATA_IDS");
		if(null != DATA_IDS && !"".equals(DATA_IDS)){
			String ArrayDATA_IDS[] = DATA_IDS.split(",");
			kycstoreService.deleteAll(ArrayDATA_IDS);
			pd.put("msg", "ok");
		}else{
			pd.put("msg", "no");
		}
		pdList.add(pd);
		map.put("list", pdList);
		return AppUtil.returnObject(pd, map);
	}
	
	 /**导出到excel
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/excel")
	public ModelAndView exportExcel() throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"导出KycStore到excel");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "cha")){return null;}
		ModelAndView mv = new ModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		Map<String,Object> dataMap = new HashMap<String,Object>();
		List<String> titles = new ArrayList<String>();
		titles.add("用户表主键ID");	//1
		titles.add("店铺名称");	//2
		titles.add("店铺持有人ID");	//3
		titles.add("店铺持有人名称");	//4
		titles.add("店铺所在平台CODE编码");	//5
		titles.add("店铺所在平台名称");	//6
		titles.add("店铺所在站点CODE编码");	//7
		titles.add("店铺所在站点名称");	//8
		titles.add("店铺情况(1-已有产品售卖,0-暂无产品售卖／暂无店铺)");	//9
		titles.add("店铺网址");	//10
		titles.add("预估月收款总额-单位（万美元）");	//11
		titles.add("卖家编号");	//12
		titles.add("MWS授权令牌");	//13
		titles.add("授权状态：0：未授权 1：已经授权但调用失败 2:已经授权但没有确认第一笔回款 3：已授权且收到了回款 4：授权被取消");	//14
		titles.add("确认收到第一笔回款时的绑定时间，如果用户中间解绑，时间会重置。");	//15
		titles.add("店铺是否是启用的状态。");	//16
		titles.add("店铺状态[0:未绑定, 1:已绑定]");	//17
		titles.add("处理状态(TRADE_UNPROCESSED-未处理，TRADE_PROCESSED-已处理)");	//18
		titles.add("备注20");	//19
		titles.add("创建人名称");	//20
		titles.add("创建日期");	//21
		titles.add("备注23");	//22
		titles.add("更新人名称");	//23
		titles.add("更新日期");	//24
		titles.add("说明");	//25
		titles.add("是否删除[0:不删除, 1:删除]");	//26
		dataMap.put("titles", titles);
		List<PageData> varOList = kycstoreService.listAll(pd);
		List<PageData> varList = new ArrayList<PageData>();
		for(int i=0;i<varOList.size();i++){
			PageData vpd = new PageData();
			vpd.put("var1", varOList.get(i).getString("KYC_NATURAL_ID"));	    //1
			vpd.put("var2", varOList.get(i).getString("STORE_NAME"));	    //2
			vpd.put("var3", varOList.get(i).getString("STORE_HOLD_PERSON_ID"));	    //3
			vpd.put("var4", varOList.get(i).getString("STORE_HOLD_PERSON_NAME"));	    //4
			vpd.put("var5", varOList.get(i).getString("STORE_PLATEFORM_CODE"));	    //5
			vpd.put("var6", varOList.get(i).getString("STORE_PLATEFORM_NAME"));	    //6
			vpd.put("var7", varOList.get(i).getString("STORE_THE_SITE_CODE"));	    //7
			vpd.put("var8", varOList.get(i).getString("STORE_THE_SITE_NAME"));	    //8
			vpd.put("var9", (Boolean) varOList.get(i).get("STORE_SITUATION") ? "是" : "否");	//9
			vpd.put("var10", varOList.get(i).getString("STORE_URL"));	    //10
			vpd.put("var11", varOList.get(i).get("MONTH_AMT").toString());	//11
			vpd.put("var12", varOList.get(i).getString("SELL_ID"));	    //12
			vpd.put("var13", varOList.get(i).getString("MWS_AUTH_TOKEN"));	    //13
			vpd.put("var14", varOList.get(i).get("AUTH_STATUS").toString());	//14
			vpd.put("var15", varOList.get(i).get("AUTH_WITH_ACCOUNT_DATE")  == null ? "" : varOList.get(i).get("AUTH_WITH_ACCOUNT_DATE").toString());	//15
			vpd.put("var16", (Boolean) varOList.get(i).get("ENABLE") ? "是" : "否");	//16
			vpd.put("var17", (Boolean) varOList.get(i).get("STATUS") ? "是" : "否");	//17
			vpd.put("var18", varOList.get(i).getString("PROCESS_STATUS"));	    //18
			vpd.put("var19", varOList.get(i).getString("CREATE_ID"));	    //19
			vpd.put("var20", varOList.get(i).getString("CREATE_NAME"));	    //20
			vpd.put("var21", varOList.get(i).get("CREATE_DTS")  == null ? "" : varOList.get(i).get("CREATE_DTS").toString());	//21
			vpd.put("var22", varOList.get(i).getString("UPDATE_ID"));	    //22
			vpd.put("var23", varOList.get(i).getString("UPDATE_NAME"));	    //23
			vpd.put("var24", varOList.get(i).get("UPDATE_DTS")  == null ? "" : varOList.get(i).get("UPDATE_DTS").toString());	//24
			vpd.put("var25", varOList.get(i).getString("JS_REMARK"));	    //25
			vpd.put("var26", (Boolean) varOList.get(i).get("DEL_FLAG") ? "是" : "否");	//26
			varList.add(vpd);
		}
		dataMap.put("varList", varList);
		ObjectExcelView erv = new ObjectExcelView();
		mv = new ModelAndView(erv,dataMap);
		return mv;
	}
	
	@InitBinder
	public void initBinder(WebDataBinder binder){
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		binder.registerCustomEditor(Date.class, new CustomDateEditor(format,true));
	}
}
