package com.js.manage.controller.pay.kycnatural;

import java.io.PrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;

import cn.hutool.core.util.IdUtil;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.js.dal.dao.model.KycNatural;
import com.js.manage.util.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.js.manage.controller.base.BaseController;
import com.js.manage.entity.Page;
import com.js.manage.service.pay.kycnatural.KycNaturalManager;
import com.js.dal.dao.mapper.KycNaturalMapper;
import tk.mybatis.mapper.entity.Example;

/** 
 * 说明：平台用户
 * 创建人：FH Q313596790
 * 创建时间：2019-09-03
 */
@Controller
@RequestMapping(value="/kycnatural")
public class KycNaturalController extends BaseController {
	String menuUrl = "kycnatural/list.do"; //菜单地址(权限用)
	@Resource(name="kycnaturalService")
	private KycNaturalManager kycnaturalService;

    @Autowired
    KycNaturalMapper kycNaturalMapper;
	
	/**保存
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/save")
	public ModelAndView save(KycNatural kycNatural) throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"新增KycNatural");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "add")){return null;} //校验权限
		ModelAndView mv = this.getModelAndView();
		kycNatural.setId(IdUtil.simpleUUID());
		kycNaturalMapper.insertSelective(kycNatural);
		mv.addObject("msg","success");
		mv.setViewName("save_result");
		return mv;
	}
	
	/**删除
	 * @param out
	 * @throws Exception
	 */
	@RequestMapping(value="/delete")
	public void delete(PrintWriter out) throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"删除KycNatural");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "del")){return;} //校验权限
		PageData pd = new PageData();
		pd = this.getPageData();
		kycnaturalService.delete(pd);
		out.write("success");
		out.close();
	}
	
	/**修改
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/edit")
	public ModelAndView edit(KycNatural kycNatural) throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"修改KycNatural");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "edit")){return null;} //校验权限
		ModelAndView mv = this.getModelAndView();
		kycNaturalMapper.updateByPrimaryKeySelective(kycNatural);
		mv.addObject("msg","success");
		mv.setViewName("save_result");
		return mv;
	}
	
	/**列表
	 * @param page
	 * @throws Exception
	 */
	@RequestMapping(value="/list")
	public ModelAndView list(Page page) throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"列表KycNatural");
		//if(!Jurisdiction.buttonJurisdiction(menuUrl, "cha")){return null;} //校验权限(无权查看时页面会有提示,如果不注释掉这句代码就无法进入列表页面,所以根据情况是否加入本句代码)
		ModelAndView mv = this.getModelAndView();
		Example example = new Example(KycNatural.class);
		PageHelper.startPage(page.getCurrentPage2(), page.getShowCount());
		List<KycNatural> varList = kycNaturalMapper.selectByExample(example);
		PageInfo<KycNatural> pageInfo = PageInfo.of(varList);
		page.setPageFromPageInfo(pageInfo);
		mv.setViewName("pay/kycnatural/kycnatural_list");
		mv.addObject("varList", BeanUtil.listBeanToMap(varList));
		//mv.addObject("pd", BeanUtil.beanToMap(XXXXReq)); // 如果需要搜索功能则放开
		mv.addObject("QX",Jurisdiction.getHC());	//按钮权限
		return mv;
	}
	
	/**去新增页面
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/goAdd")
	public ModelAndView goAdd()throws Exception{
		ModelAndView mv = this.getModelAndView();
		mv.setViewName("pay/kycnatural/kycnatural_edit");
		mv.addObject("msg", "save");
		return mv;
	}	
	
	 /**去修改页面
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/goEdit")
	public ModelAndView goEdit(String id) throws Exception{
		ModelAndView mv = this.getModelAndView();
		KycNatural kycNatural = kycNaturalMapper.selectByPrimaryKey(id);
		mv.setViewName("pay/kycnatural/kycnatural_edit");
		mv.addObject("msg", "edit");
		mv.addObject("pd", BeanUtil.beanToMap(kycNatural));
		return mv;
	}	
	
	 /**批量删除
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/deleteAll")
	@ResponseBody
	public Object deleteAll() throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"批量删除KycNatural");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "del")){return null;} //校验权限
		PageData pd = new PageData();
		Map<String,Object> map = new HashMap<String,Object>();
		pd = this.getPageData();
		List<PageData> pdList = new ArrayList<PageData>();
		String dataIds = pd.getString("dataIds");
		if(null != dataIds && !"".equals(dataIds)){
			String arrayDataIds[] = dataIds.split(",");
			kycnaturalService.deleteAll(arrayDataIds);
			pd.put("msg", "ok");
		}else{
			pd.put("msg", "no");
		}
		pdList.add(pd);
		map.put("list", pdList);
		return AppUtil.returnObject(pd, map);
	}
	
	 /**导出到excel
	 * @param
	 * @throws Exception
	 */
	@RequestMapping(value="/excel")
	public ModelAndView exportExcel() throws Exception{
		logBefore(logger, Jurisdiction.getUsername()+"导出KycNatural到excel");
		if(!Jurisdiction.buttonJurisdiction(menuUrl, "cha")){return null;}
		ModelAndView mv = new ModelAndView();
		PageData pd = new PageData();
		pd = this.getPageData();
		Map<String,Object> dataMap = new HashMap<String,Object>();
		List<String> titles = new ArrayList<String>();
		titles.add("性别(MALE-男，FEMALE-女)");	//1
		titles.add("注册类型（1-中国大陆-个人，2-中国大陆-企业，3-中国香港-个人，4-中国香港-企业）");	//2
		titles.add("实名名称（类型为个人填写客户姓名，类型为企业填写企业名称）");	//3
		titles.add("证件号");	//4
		titles.add("注册手机号");	//5
		titles.add("注册邮箱");	//6
		titles.add("邮箱是否激活(0:未激活, 1:已激活)");	//7
		titles.add("实名认证状态");	//8
		titles.add("备注");	//9
		titles.add("邀请码");	//10
		titles.add("备注12");	//11
		titles.add("备注13");	//12
		titles.add("注册日期");	//13
		titles.add("备注15");	//14
		titles.add("备注16");	//15
		titles.add("更新时间");	//16
		titles.add("是否删除[0:不删除, 1:删除]");	//17
		titles.add("是否通过经营者备案[1是，0否]");	//18
		dataMap.put("titles", titles);
		List<PageData> varOList = kycnaturalService.listAll(pd);
		List<PageData> varList = new ArrayList<PageData>();
		for(int i=0;i<varOList.size();i++){
			PageData vpd = new PageData();
			vpd.put("var1", varOList.get(i).getString("sex"));	    //1
			vpd.put("var2", varOList.get(i).getString("register_type"));	    //2
			vpd.put("var3", varOList.get(i).getString("certification_name"));	    //3
			vpd.put("var4", varOList.get(i).getString("id_no"));	    //4
			vpd.put("var5", varOList.get(i).getString("phone_no"));	    //5
			vpd.put("var6", varOList.get(i).getString("email"));	    //6
			vpd.put("var7", (Boolean) varOList.get(i).get("email_active_flag") ? "是" : "否");	//7
			vpd.put("var8", varOList.get(i).getString("certification_status"));	    //8
			vpd.put("var9", varOList.get(i).getString("js_remark"));	    //9
			vpd.put("var10", varOList.get(i).getString("invite_code"));	    //10
			vpd.put("var11", varOList.get(i).getString("create_id"));	    //11
			vpd.put("var12", varOList.get(i).getString("create_name"));	    //12
			vpd.put("var13", varOList.get(i).get("create_dts")  == null ? "" : varOList.get(i).get("create_dts").toString());	//13
			vpd.put("var14", varOList.get(i).getString("update_id"));	    //14
			vpd.put("var15", varOList.get(i).getString("update_name"));	    //15
			vpd.put("var16", varOList.get(i).get("update_dts")  == null ? "" : varOList.get(i).get("update_dts").toString());	//16
			vpd.put("var17", (Boolean) varOList.get(i).get("del_flag") ? "是" : "否");	//17
			vpd.put("var18", (Boolean) varOList.get(i).get("record_flag") ? "是" : "否");	//18
			varList.add(vpd);
		}
		dataMap.put("varList", varList);
		ObjectExcelView erv = new ObjectExcelView();
		mv = new ModelAndView(erv,dataMap);
		return mv;
	}
	
	@InitBinder
	public void initBinder(WebDataBinder binder){
		DateFormat format = new SimpleDateFormat("yyyy-MM-dd");
		binder.registerCustomEditor(Date.class, new CustomDateEditor(format,true));
	}
}
