package com.js.manage.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.JsPayXGServicesRecordVO;
import com.js.common.model.vo.KycCertiContactsVO;
import com.js.common.model.vo.KycCertiLinkFileVO;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycNaturalService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class JsKycNaturalServiceImpl implements JsKycNaturalService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiKycNaturalService apiKycNaturalService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsKycChargeService apiJsKycChargeService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiJsPayXGantiMoneyService apiJsPayXGantiMoneyService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0
    )
    ApiKycCertiContactsService apiKycCertiContactsService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0
    )
    ApiKycCertiLinkFileService apiKycCertiLinkFileService;

    @Override
    public String getKycNaturalList(KycNaturalListReq kycNaturalListReq) {
        return apiKycNaturalService.getKycNaturalList(kycNaturalListReq);
    }

    @Override
    public ResponseMessage getKycNatural(String id) {
        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(id);
        if (ObjectUtil.isNotEmpty(kycNaturalVO)) {
            return ResultUtil.success(kycNaturalVO, ResultEnum.QUERY_SUCCESS);
        } else {
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
    }

    @Override
    public ResponseMessage getKycNaturalAntiMoneyInfo(String kycNaturaId) {
        JsPayXGServicesRecordVO jsPayXGServicesRecordVO = apiJsPayXGantiMoneyService.queryXGServicesRecords(kycNaturaId);
        if (ObjectUtil.isNotEmpty(jsPayXGServicesRecordVO)) {
            return ResultUtil.success(jsPayXGServicesRecordVO, ResultEnum.QUERY_SUCCESS);
        } else {
            return ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
    }

    @Override
    public ResponseMessage updateXGServicesStatusById(String id,String certificationStatus) {
        return apiJsPayXGantiMoneyService.updateXGServicesStatusById(id,certificationStatus);
    }

    @Override
    public ResponseMessage updateKycNaturalStatusById(String kycNaturaId ,String certificationStatus) {
        return apiKycNaturalService.updateKycNaturalStatusById(kycNaturaId,certificationStatus);
    }

    @Override
    public int updateKycNatural(KycNaturalReq kycNaturalReq) {
        return apiKycNaturalService.updateKycNatural(kycNaturalReq);
    }

    @Override
    public int deleteKycNatural(String id) {
        return apiKycNaturalService.deleteKycNaturaById(id);
    }

    @Override
    public ResponseMessage getKycNaturalDetail(String id, RegisterType registerType) {
        JSONObject certiInfo = apiSunrateTradePriceService.findCertiInfo(id, registerType);
        if(RegisterType.MAINLAND_COMPANY.equals(registerType) || RegisterType.HK_COMPANY.equals(registerType)){
            KycCertiContactsReq kycCertiContactsReq = new KycCertiContactsReq();
            kycCertiContactsReq.setKycNaturalId(id);
            ResponseMessage kycCertiContacts = apiKycCertiContactsService.getKycCertiContacts(kycCertiContactsReq);
            if(kycCertiContacts.isSuccess()){
                List<KycCertiContactsVO> kycCertiContactsVOList = (List<KycCertiContactsVO>)kycCertiContacts.getData();
                JSONArray jsonArray = new JSONArray();
                kycCertiContactsVOList.stream().forEach(kycCertiContactsVO -> {
                    JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(kycCertiContactsVO));
                    KycCertiLinkFileReq kycCertiLinkFileReq = new KycCertiLinkFileReq();
                    kycCertiLinkFileReq.setContactsId(kycCertiContactsVO.getId());
                    List<KycCertiLinkFileVO> certiFileList = apiKycCertiLinkFileService.findCertiFileList(kycCertiLinkFileReq);
                    certiFileList.stream().forEach(kycCertiLinkFileVO -> {
                        jsonObject.put(kycCertiLinkFileVO.getFileType().name(),kycCertiLinkFileVO.getFileSavePath());
                    });
                    jsonArray.add(jsonObject);
                });
                certiInfo.put("contractsInfo",jsonArray);
            }
        }
        return ResultUtil.success(certiInfo);
    }

    @Override
    public ResponseMessage auditKycNatural(KycNaturalReq kycNaturalReq) {
        if(StringUtils.isNotBlank(kycNaturalReq.getJsRemark()) && kycNaturalReq.getJsRemark().length() > 300){
            log.error("审核备注超长300：{}",kycNaturalReq.getJsRemark().length());
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        return apiKycNaturalService.auditKycNatural(kycNaturalReq);
    }

    @Override
    public JSONObject getKycChargeList(String kycNaturalId) {
        JsKycChargeReq jsKycChargeReq = new JsKycChargeReq();
        jsKycChargeReq.setKycNaturalId(kycNaturalId);
        return apiJsKycChargeService.findKycChargeList(jsKycChargeReq);
    }

    @Override
    public ResponseMessage operateKycChargeInfo(JsKycChargeReq jsKycChargeReq) {
        return apiJsKycChargeService.operateKycChargeInfo(jsKycChargeReq);
    }
}
