package com.js.manage.service.impl;

import com.aliyun.oss.OSSClient;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.FileMngForOSSUtil;
import com.js.manage.properties.JswebOSSPropertie;
import com.js.manage.service.JsFileSerivce;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.InputStream;

@Service("jsFileService")
public class JsFileServiceImpl implements JsFileSerivce {
    @Autowired
    JswebOSSPropertie jswebOSSPropertie;
    @Autowired
    OSSClient oSSClient;

    @Override
    public InputStream findFile(String fileUrl) {
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), null, oSSClient);
        return fileUploadForOSSUtil.findFile(fileUrl);
    }

    @Override
    public ResponseMessage deleteFile(String fileUrl) {
        FileMngForOSSUtil fileUploadForOSSUtil = new FileMngForOSSUtil(jswebOSSPropertie.getBucket(), null, oSSClient);
        return fileUploadForOSSUtil.deleteFile(fileUrl);
    }
}
