package com.js.manage.controller;

import cn.hutool.json.JSONUtil;
import com.js.common.constant.Constant;
import com.js.common.enums.HolType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsSystemHolidayReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsSysHolidaysService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

/**
 * @Author liuh
 * @Description 平台三方账户管理
 * @Date 2019/8/23
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class JsSysHolidaysController {

    @Autowired
    JsSysHolidaysService jsSysHolidaysService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsSysHolidays/list.html")
    public String listInput() {
        return "js_sys_holidays/list";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsSysHolidays/getJsSystemHolidayList" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getJsSystemHolidayList(JsSystemHolidayReq jsSystemHolidayReq) {
        return JSONUtil.parseObj(jsSysHolidaysService.getJsSystemHolidayList(jsSystemHolidayReq));
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON + "/jsSysHolidays/addNewSysHolidays")
    @ResponseBody
    public ResponseMessage addNewSysHolidays(Integer exeDays){
        return jsSysHolidaysService.addNewSysHolidays(exeDays);
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON + "/jsSysHolidays/changeHolType")
    @ResponseBody
    public ResponseMessage changeHolType(JsSystemHolidayReq jsSystemHolidayReq){
        log.info("编辑节假日信息入参：{}", jsSystemHolidayReq);
        if(StringUtils.isBlank(jsSystemHolidayReq.getId())){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        return jsSysHolidaysService.changeHolType(jsSystemHolidayReq);
    }
}
