package com.js.manage.controller;

import cn.hutool.json.JSONUtil;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsPayTradeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author liuh
 * @Description 交易管理
 * @Date 2019/7/9
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class JsPayTradeController {
    @Autowired
    JsPayTradeService jsPayTradeService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPayTrade/tradeInList.html")
    public String toTradeInListPage() {
        return "js_pay_trade/tradeInList";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsPayTrade/getPayTradeInList",produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getPayTradeInList(JsTradeListReq jsTradeListReq) {
        return JSONUtil.parseObj(jsPayTradeService.getPayTradeInList(jsTradeListReq));
    }

    /**
     * @Author liuh
     * @Description 入账处理
     * @Date 2019-08-29
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPayTrade/tradeInProcess", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage tradeInProcess(String tradeIds,String remark) {
        log.info("未入账数据进行入账处理：{}", tradeIds);
        if (StringUtils.isBlank(tradeIds) || StringUtils.isBlank(remark)) {
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        ResponseMessage responseMessage = jsPayTradeService.tradeInProcess(tradeIds,remark);
        return responseMessage;
    }

    /**
     * @Author liuh
     * @Description 无需入账处理
     * @Date 2019-08-29
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPayTrade/tradeNotInProcess", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage tradeNotInProcess(String tradeIds,String remark) {
        log.info("无需入账数据进行入账处理：{}", tradeIds);
        if (StringUtils.isBlank(tradeIds) || StringUtils.isBlank(remark)) {
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        ResponseMessage responseMessage = jsPayTradeService.tradeNotInProcess(tradeIds,remark);
        return responseMessage;
    }
}
