package com.js.manage.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.RegisterType;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.SiteEnum;
import com.js.common.model.req.JsKycChargeReq;
import com.js.common.model.req.JsPayXGServicesRecordReq;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycNaturalService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;

/**
 *
 * @Author liuty
 * @Description 用户 kyc controller
 * @Date 2019/6/27
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class JsKycNaturalController {

    @Autowired
    JsKycNaturalService jsKycNaturalService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/list.html")
    public String listInput() {
        return "kyc_natural/list";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/view.html")
    public String viewInput(String id, ModelMap model) {
        ResponseMessage kycNatural;
        if(ObjectUtil.isNotEmpty(id)) {
            kycNatural = jsKycNaturalService.getKycNatural(id);
        } else {
            kycNatural = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute(kycNatural);
        return "kyc_natural/view";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/info.html")
    public String infoInput(String id, ModelMap model) {
        ResponseMessage jsPayXGServicesRecord;
        if(ObjectUtil.isNotEmpty(id)) {
            jsPayXGServicesRecord = jsKycNaturalService.getKycNaturalAntiMoneyInfo(id);
        } else {
            jsPayXGServicesRecord = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute(jsPayXGServicesRecord);
        return "kyc_natural/antiMoneyInfo";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/auditPass", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage auditPass(JsPayXGServicesRecordReq jsPayXGServicesRecordReq, ModelMap model) {
        log.info("反洗钱信息审核通过操作,JsPayXGServicesRecordReq:{}", JSON.toJSONString(jsPayXGServicesRecordReq));
        if(!CertiStatusEnum.AUDIT_UNKNOWN.toString().equals(jsPayXGServicesRecordReq.getStatus())){
            return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "已审核，操作无效果;");
        }
        int i = 0;
        if (ObjectUtil.isNotEmpty(jsPayXGServicesRecordReq.getId())) {
            if (ObjectUtil.isNotEmpty(jsPayXGServicesRecordReq.getKycNaturalId())) {
                String id = jsPayXGServicesRecordReq.getId();
                ResponseMessage responseMessage = jsKycNaturalService.updateXGServicesStatusById(id, CertiStatusEnum.AUDIT_PASS.toString());
                if(responseMessage.isSuccess() && responseMessage.getData() != null){
                    i = Integer.valueOf(responseMessage.getData().toString());
                    if(i != 0){
                        String kycNaturalId = jsPayXGServicesRecordReq.getKycNaturalId();
                        responseMessage = jsKycNaturalService.updateKycNaturalStatusById(kycNaturalId, CertiStatusEnum.SUBMIT_FIRST_TRIAL.toString());
                        if(responseMessage.isSuccess() && responseMessage.getData() != null){
                            i = Integer.valueOf(responseMessage.getData().toString());
                            if (i != 0) {
                                return ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
                            }
                        }
                    }
                }
            }else{
                return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "反洗钱信息审核通过操作出错，kycNaturalId 为空；");
            }
        } else {
            return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "反洗钱信息审核通过操作出错,id 为空；");
        }
        return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "反洗钱信息审核通过操作出错;");
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/auditRefuse", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage auditRefuse(JsPayXGServicesRecordReq jsPayXGServicesRecordReq, ModelMap model) {
        log.info("反洗钱信息审核拒绝操作,JsPayXGServicesRecordReq:{}", JSON.toJSONString(jsPayXGServicesRecordReq));
        if(!CertiStatusEnum.AUDIT_UNKNOWN.toString().equals(jsPayXGServicesRecordReq.getStatus())){
            return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "已审核，操作无效果;");
        }
        int i = 0;
        if (ObjectUtil.isNotEmpty(jsPayXGServicesRecordReq.getId())) {
            if (ObjectUtil.isNotEmpty(jsPayXGServicesRecordReq.getKycNaturalId())) {
                String id = jsPayXGServicesRecordReq.getId();
                ResponseMessage responseMessage = jsKycNaturalService.updateXGServicesStatusById(id, CertiStatusEnum.AUDIT_RERUSE.toString());
                if(responseMessage.isSuccess() && responseMessage.getData() != null){
                    i = Integer.valueOf(responseMessage.getData().toString());
                    if(i != 0){
                        String kycNaturalId = jsPayXGServicesRecordReq.getKycNaturalId();
                        responseMessage = jsKycNaturalService.updateKycNaturalStatusById(kycNaturalId, CertiStatusEnum.AUDIT_RERUSE.toString());
                        if(responseMessage.isSuccess() && responseMessage.getData() != null){
                            i = Integer.valueOf(responseMessage.getData().toString());
                            if (i != 0) {
                                return ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
                            }
                        }
                    }
                }
            }else{
                return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "反洗钱信息审核拒绝操作出错，kycNaturalId 为空；");
            }
        } else {
            return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "反洗钱信息审核拒绝操作出错,id 为空；");
        }
        return ResultUtil.error(ResultEnum.UPDATE_ERROR.getCode(), "反洗钱信息审核拒绝操作出错;");
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/edit.html")
    public String editInput(String id, ModelMap model) {
        ResponseMessage kycNatural = null;
        if(ObjectUtil.isNotEmpty(id)) {
            kycNatural = jsKycNaturalService.getKycNatural(id);
        }
        if(ObjectUtil.isEmpty(kycNatural)) {
            kycNatural = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute(kycNatural);
        return "kyc_natural/edit";
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/delete", method = RequestMethod.GET)
    @ResponseBody
    public ResponseMessage delete(String id) {
        if(ObjectUtil.isNotEmpty(id)) {
            int i = jsKycNaturalService.deleteKycNatural(id);
            if (i != 0) {
                return ResultUtil.success(ResultEnum.DELETE_SUCCESS);
            } else {
                return ResultUtil.error(ResultEnum.DELETE_ERROR);
            }
        } else {
            return ResultUtil.error(ResultEnum.DELETE_ERROR);
        }
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/save", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage save(KycNaturalReq kycNaturalReq) {
        if (ObjectUtil.isNotEmpty(kycNaturalReq.getId())) {
            if (ObjectUtil.isEmpty(kycNaturalReq.getEmailActiveFlag())) {
                kycNaturalReq.setEmailActiveFlag(false);
            }
            if (ObjectUtil.isEmpty(kycNaturalReq.getRecordFlag())) {
                kycNaturalReq.setRecordFlag(false);
            }
            int i = jsKycNaturalService.updateKycNatural(kycNaturalReq);
            if (i != 0) {
                return ResultUtil.success(ResultEnum.UPDATE_SUCCESS);
            } else {
                return ResultUtil.error(ResultEnum.UPDATE_ERROR);
            }
        } else {
            return ResultUtil.error(ResultEnum.SAVE_ERROR.getCode(), "后台不允许添加用户");
        }
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsNatural/getKycNaturalList" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getKycNaturalList(KycNaturalListReq kycNaturalListReq) {
        return JSONUtil.parseObj(jsKycNaturalService.getKycNaturalList(kycNaturalListReq));
    }

    //跳转到审核查看编辑页面
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/audit.html",produces = "text/html;charset=UTF-8")
    public String auditInput(String id, RegisterType registerType,String operateType, ModelMap model) {
        log.info("registerType:{}" , registerType);
        ResponseMessage kycNaturalDetail = null;
        if(ObjectUtil.isNotEmpty(id) && null != registerType) {
            kycNaturalDetail = jsKycNaturalService.getKycNaturalDetail(id,registerType);
        }
        if(ObjectUtil.isEmpty(kycNaturalDetail)) {
            kycNaturalDetail = ResultUtil.error(ResultEnum.QUERY_ERROR);
        }
        model.addAttribute("operateType",operateType);
        model.addAttribute(kycNaturalDetail);
        String auditPage = "kyc_natural/view";
        if(RegisterType.MAINLAND_PERSONAL.equals(registerType)){
            auditPage = "kyc_natural/mainland_personal";
        }else if(RegisterType.MAINLAND_COMPANY.equals(registerType)){
            auditPage = "kyc_natural/mainland_company";
        }else if(RegisterType.HK_PERSONAL.equals(registerType)){
            auditPage = "kyc_natural/hk_personal";
        }else if(RegisterType.HK_COMPANY.equals(registerType)){
            auditPage = "kyc_natural/hk_company";
        }
        return auditPage;
    }

    /**
     * @Author liuh
     * @Description 审核处理
     * @Date 2019-08-02
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/updateAuditInfo", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage updateAuditInfo(KycNaturalReq kycNaturalReq) {
        log.info("审核结果入参：{}", JSONUtil.toJsonStr(kycNaturalReq));
        if (ObjectUtil.isEmpty(kycNaturalReq.getId())) {
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
        ResponseMessage responseMessage = jsKycNaturalService.auditKycNatural(kycNaturalReq);
        return responseMessage;
    }

    /**
     * 获取当前登录用户费率比配置信息
     * @Author liuh
     * @Date 2019/8/14
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsNatural/getKycChargeList" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getKycChargeList(String kycNaturalId) {
        return jsKycNaturalService.getKycChargeList(kycNaturalId);
    }

    //跳转到查看编辑费率比页面
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/kycCharge.html",produces = "text/html;charset=UTF-8")
    public String kycChargeInput(String id, RegisterType registerType, ModelMap model) {
        log.info("registerType:{}" , registerType);
        model.addAttribute("defaultServiceCharge", SiteEnum.NORTH_AMERICA_SITE.getJsTradeServiceChargeValue());
        model.addAttribute("dafaultRate",0);
        String kycChargePage = "kyc_natural/kyc_charge";
        return kycChargePage;
    }

    /**
     * @Author liuh
     * @Description 费率编辑
     * @Date 2019-08-14
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/operateKycChargeInfo", method = RequestMethod.POST)
    @ResponseBody
    public ResponseMessage operateKycChargeInfo(@Valid JsKycChargeReq jsKycChargeReq) {
        log.info("新增或编辑收费信息：{}", jsKycChargeReq);
        ResponseMessage responseMessage = jsKycNaturalService.operateKycChargeInfo(jsKycChargeReq);
        return responseMessage;
    }

    /**
     * @Author liuh
     * @Description 跳转到受益人管理页
     * @Date 2019-08-25
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsNatural/kycBeneficiary.html",produces = "text/html;charset=UTF-8")
    public String kycBeneficiaryPage(String id) {
        log.info("跳转到KYC受益人编辑页面，kycNaturalId:{}" , id);
        return "kyc_natural/kyc_beneficiary";
    }
}
