package com.js.manage.controller;

import cn.hutool.json.JSONUtil;
import com.js.common.constant.Constant;
import com.js.common.model.req.KycDictionaryReq;
import com.js.common.model.vo.KycDictionaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.manage.service.JsKycDictionaryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *
 * @Author liuh
 * @Description 字典表
 * @Date 2019/8/20
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class JsKycDictionaryController {

    @Autowired
    JsKycDictionaryService jsKycDictionaryService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/list.html")
    public String listInput() {
        return "kyc_dictionary/list";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsKycDictionary/getKycDictionaryRootList" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getKycDictionaryRootList(KycDictionaryReq kycDictionaryReq) {
        return JSONUtil.parseObj(jsKycDictionaryService.getKycDictionaryRootList(kycDictionaryReq));
    }

    /**
     * @Author liuh
     * @Description 跳转到编辑字典表页面
     * @Date 2019/8/20
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/toDetailList.html",produces = "text/html;charset=UTF-8")
    public String toDetailList() {
        return "kyc_dictionary/edit";
    }

    /**
     * @Author liuh
     * @Description 新增或编辑字典表
     * @Date 2019/8/21
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/saveOrUpdate")
    @ResponseBody
    public ResponseMessage save(KycDictionaryReq kycDictionaryReq) {
        log.info("新增或编辑字典表入参：{}",kycDictionaryReq);
        return jsKycDictionaryService.operateKycDictionary(kycDictionaryReq);
    }

    /**
     * @Author liuh
     * @Description 跳转到新增类别页面
     * @Date 2019/8/21
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/toAddDicPage.html")
    public String toAddDicPage() {
        return "kyc_dictionary/add";
    }

    /**
     * @Author liuh
     * @Description 新增或编辑字典表ROOT类别
     * @Date 2019/8/21
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/saveOrUpdateRoot")
    @ResponseBody
    public ResponseMessage saveOrUpdateRoot(KycDictionaryReq kycDictionaryReq) {
        log.info("新增或编辑字典表ROOT类别入参：{}",kycDictionaryReq);
        return jsKycDictionaryService.operateKycDictionaryRoot(kycDictionaryReq);
    }

    /**
     * @Author liuh
     * @Description 跳转到编辑类别页面
     * @Date 2019/8/21
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/toEditDicPage.html")
    public String toEditDicPage(String id,ModelMap model) {
        KycDictionaryVO kycDictionaryVO = jsKycDictionaryService.getKycDictionary(id);
        model.addAttribute("kycDictionaryVO" ,kycDictionaryVO);
        return "kyc_dictionary/edit_root";
    }

    /**
     * @Author liuh
     * @Description 跳转到查看类别页面
     * @Date 2019/8/22
     */
    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycDictionary/toViewDicPage.html")
    public String toViewDicPage(String id,ModelMap model) {
        KycDictionaryVO kycDictionaryVO = jsKycDictionaryService.getKycDictionary(id);
        model.addAttribute("kycDictionaryVO" ,kycDictionaryVO);
        return "kyc_dictionary/view_root";
    }
}
