﻿<!DOCTYPE html>
<html>
<head>
	<meta charset="UTF-8">
	<title>节假日管理</title>
	<link rel="stylesheet" href="../../../../plugins/layui/css/layui.css" media="all" />
	<link rel="stylesheet" href="../../../../css/global.css" media="all">
	<link rel="stylesheet" href="../../../../plugins/font-awesome/css/font-awesome.min.css">
	<link rel="stylesheet" href="../../../../css/table.css" />
	<link rel="stylesheet" href="../../../../css/custom.css" />
</head>

<body>
<div class="admin-main">
	<blockquote class="layui-elem-quote" style="height: 30px">
		<div class="layui-form" style="float:right;">
			<div class="layui-form-item">
				<label class="layui-form-label">日期</label>
				<div class="layui-input-inline">
					<input type="text" name="holDate" id="date" placeholder="yyyy-MM-dd" autocomplete="off" class="layui-input">
				</div>
				<label class="layui-form-label">类型</label>
				<div class="layui-input-inline">
					<select name="holType" id="holType">
						<option value="">请选择</option>
						<option value="HOLIDAYS">节假日</option>
						<option value="WORKING_DAYS">工作日</option>
					</select>
				</div>
				<div class="layui-form-mid layui-word-aux" style="padding:0;">
					<button id="search" lay-filter="search" class="layui-btn" lay-submit><i class="fa fa-search" aria-hidden="true"></i> 查询</button>
				</div>
			</div>
		</div>
	</blockquote>

	<fieldset class="layui-elem-field">
		<legend>节假日列表</legend>
		&nbsp;&nbsp;&nbsp;&nbsp;
		<button type="button" class="layui-btn layui-btn-small" id="addDaysBtn">执行日期插入</button>
		<button type="button" class="layui-btn layui-btn-small layui-btn-normal" id="updateTypeBtn">修改类型</button>
		<button type="button" class="layui-btn layui-btn-small layui-btn-normal" id="updateDescBtn">修改描述</button>
		<div class="layui-field-box layui-form">
			<table class="layui-table admin-table" style="table-layout:fixed;word-wrap:break-word;">
				<thead>
				<tr>
					<th style="width: 20px;"></th>
					<th>日期</th>
					<th>类型</th>
					<th>描述</th>
					<th>创建时间</th>
					<th>更新时间</th>
				</tr>
				</thead>
				<tbody id="content">
				</tbody>
			</table>
		</div>
	</fieldset>
	<div class="admin-table-page">
		<div id="paged" class="page">
		</div>
	</div>
</div>
<!--模板-->
<script type="text/html" id="tpl">
	{{# layui.each(d.list, function(index, item){ }}
	<tr>
		<td><input type="radio" name="jsSysHolidaysRadio" style="display: table" data-id="{{ item.id }}" data-holtype="{{ item.holType }}"></td>
		<td>{{ item.holDateStr}}</td>
		<td>{{ item.holTypeDesc }}</td>
		<td>{{ item.holDesc }}</td>
		<td>{{ item.createDtsStr }}</td>
		<td>{{ item.updateDtsStr }}</td>
	</tr>
	{{# }); }}
</script>
<script type="text/javascript" src="../../../../plugins/layui/layui.js"></script>
<script>
	layui.config({
		base: '../../../../js/'
	});
	layui.use(['laydate','paging', 'form'], function() {
		var $ = layui.jquery,
				paging = layui.paging(),
				layerTips = parent.layer === undefined ? layui.layer : parent.layer, //获取父窗口的layer对象
				layer = layui.layer, //获取当前窗口的layer对象
				laydate = layui.laydate,
				form = layui.form();
		document.getElementById('date').onclick = function(){
			laydate({
				elem: $('#date')[0], //需显示日期的元素选择器
				// format: 'YYYY-MM-DD hh:mm:ss', //日期格式
				// istime: true, //是否开启时间选择
				// isclear: true, //是否显示清空
				// istoday: true, //是否显示今天
				issure: false //是否显示确认
			});
		}
		form.render("select");
		paging.init({
			openWait: true,
			url: '/api/v1/anon/jsSysHolidays/getJsSystemHolidayList', //地址
			elem: '#content', //内容容器
			params: {
			},
			type: 'GET',
			tempElem: '#tpl', //模块容器
			pageConfig: { //分页参数配置
				elem: '#paged', //分页容器
				pageSize: 10 //分页大小
			},
			success: function(a,b,c,d) { //渲染成功的回调
				//alert('渲染成功');
			},
			fail: function(msg) { //获取数据失败的回调
				//alert('获取数据失败')
			},
			complate: function() { //完成的回调
				console.log("列表加载完成!");
			},
		});

		$('#search').on('click', function() {
			paging.get({
				"holType" : $("#holType").val(),
				"holDate":$("#date").val()
			});
		});

		//插入新的日期
		$('#addDaysBtn').on('click', function() {
			layer.prompt({
				formType: 2,
				value: '',
				title: '请输入需要生成天数(请勿重复点击)',
				area: ['200px', '100px'], //自定义文本域宽高
				btn:['确认','取消'],
			}, function(value, index, elem){
				var r = /^\+?[1-9][0-9]*$/;　　//正整数
				var isNumber = r.test(value);
				if(isNumber){
					$.post("/api/v1/anon/jsSysHolidays/addNewSysHolidays",{exeDays : value},function(result){
						if (result.success == true) {
							layerTips.msg('执行成功');
							layer.close(index);
							location.reload(); //刷新
						} else {
							layerTips.msg(result.msg);
						}
					});
				}else{
					layerTips.msg('请正确输入天数');
				}
			});
		});

		//修改类型按钮
		$('#updateTypeBtn').on('click', function() {
			var isChecked = false;
			$('#content').children('tr').each(function() {
				var $that = $(this);
				var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
				var $cbx = $cbxDom.checked;
				if($cbx) {
					isChecked = true;
					var dateId = $cbxDom.getAttribute('data-id');
					var holType = $cbxDom.getAttribute('data-holtype');
					if(undefined == dateId || '' == dateId || undefined == holType || '' == holType){
						layer.msg('请选中操作行');
						return;
					}
					holType = 'WORKING_DAYS' == holType ? 'HOLIDAYS' : 'WORKING_DAYS';
					operatorDetailForm(dateId,holType);
					return;
				}
			});
			if(!isChecked){
				layer.msg('请选中操作行');
			}
		});

		function operatorDetailForm(dataId,holType) {
			layer.prompt({
				formType: 2,
				value: '',
				title: '请输入描述信息',
				area: ['400px', '200px'] //自定义文本域宽高
			}, function(value, index, elem){
				$.post("/api/v1/anon/jsSysHolidays/changeHolType",{id : dataId,holDesc : value,holType : holType},function(result){
					if (result.success == true) {
						layerTips.msg('修改成功');
						location.reload(); //刷新
					} else {
						layerTips.msg(result.msg);
					}
				});
			});

		}

		//修改描述按钮
		$('#updateDescBtn').on('click', function() {
			var isChecked = false;
			$('#content').children('tr').each(function() {
				var $that = $(this);
				var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
				var $cbx = $cbxDom.checked;
				if($cbx) {
					isChecked = true;
					var dateId = $cbxDom.getAttribute('data-id');
					var holType = $cbxDom.getAttribute('data-holtype');
					if(undefined == dateId || '' == dateId || undefined == holType || '' == holType){
						layer.msg('请选中操作行');
						return;
					}
					operatorDetailForm(dateId,holType);
					return;
				}
			});
			if(!isChecked){
				layer.msg('请选中操作行');
			}
		});

		function operatorDetailForm(dataId,holType) {
			layer.prompt({
				formType: 2,
				value: '',
				title: '请输入描述信息',
				area: ['400px', '200px'] //自定义文本域宽高
			}, function(value, index, elem){
				$.post("/api/v1/anon/jsSysHolidays/changeHolType",{id : dataId,holDesc : value,holType : holType},function(result){
					if (result.success == true) {
						layerTips.msg('修改成功');
						location.reload(); //刷新
					} else {
						layerTips.msg(result.msg);
					}
				});
			});
		}
	});
</script>
</body>
</html>