package com.js.manage.service.impl;

import cn.hutool.core.date.DateUtil;
import com.js.api.jspay.service.ApiJsSystemHolidaysService;
import com.js.common.constant.Constant;
import com.js.common.enums.HolType;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsSystemHolidayReq;
import com.js.common.model.vo.JsSystemHolidayVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsSysHolidaysService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.Calendar;
import java.util.Date;

@Service
@Slf4j
public class JsSysHolidaysServiceImpl implements JsSysHolidaysService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiJsSystemHolidaysService apiJsSystemHolidaysService;

    @Override
    public String getJsSystemHolidayList(JsSystemHolidayReq jsSystemHolidayReq){
        return apiJsSystemHolidaysService.getJsSystemHolidayList(jsSystemHolidayReq);
    }

    @Override
    public ResponseMessage addNewSysHolidays(Integer exeDays) {
        Date date = new Date();
        JsSystemHolidayVO jsSystemHolidayVO = apiJsSystemHolidaysService.getLastHoliday();
        if(null != jsSystemHolidayVO){
            date = jsSystemHolidayVO.getHolDate();
        }
        for(int i = 1 ;i <= exeDays ; i ++) {
            System.out.println(DateUtil.format(date,"yyyy-MM-dd"));
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(Calendar.DATE, 1);
            date = cal.getTime();
            JsSystemHolidayReq jsSystemHolidayReq = new JsSystemHolidayReq();
            jsSystemHolidayReq.setHolDate(date);
            if (cal.get(Calendar.DAY_OF_WEEK) == Calendar.SATURDAY || cal.get(Calendar.DAY_OF_WEEK) == Calendar.SUNDAY) {
                jsSystemHolidayReq.setHolType(HolType.HOLIDAYS);
                jsSystemHolidayReq.setHolDesc("双休日");
            } else {
                jsSystemHolidayReq.setHolType(HolType.WORKING_DAYS);
                jsSystemHolidayReq.setHolDesc("工作日");
            }
            int insertCount = apiJsSystemHolidaysService.addJsSystemHolidays(jsSystemHolidayReq);
            log.info("插入条数:{}",insertCount);
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage changeHolType(JsSystemHolidayReq jsSystemHolidayReq) {
        int updateCount = apiJsSystemHolidaysService.changeHolType(jsSystemHolidayReq);
        return updateCount > 0 ? ResultUtil.success(ResultEnum.SUCCESS) : ResultUtil.error(ResultEnum.ERROR);
    }
}
