﻿<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title>JS店铺列表</title>
		<link rel="stylesheet" href="../../../../plugins/layui/css/layui.css" media="all" />
		<link rel="stylesheet" href="../../../../css/global.css" media="all">
		<link rel="stylesheet" href="../../../../plugins/font-awesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../../../../css/table.css" />
		<link rel="stylesheet" href="../../../../css/custom.css" />
	</head>

	<body>
		<div class="admin-main">
            <blockquote class="layui-elem-quote" style="height: 30px">
                <div class="layui-form" style="float:right;">
                    <div class="layui-form-item">
                        <label class="layui-form-label">店铺名称</label>
                        <div class="layui-input-inline" style="width:150px;">
							<input type="text" name="storeName" id="storeName" autocomplete="off" class="layui-input">
                        </div>
                        <label class="layui-form-label" style="width: 100px">处理状态</label>
                        <div class="layui-input-inline">
                            <select name="processStatus" id="processStatus" lay-search="">
								<option value="">请选择</option>
								<option value="TRADE_PROCESSED" >已处理</option>
								<option value="TRADE_UNPROCESSED" selected>未处理</option>
                            </select>
                        </div>
                        <div class="layui-form-mid layui-word-aux" style="padding:0;">
                            <button id="search" lay-filter="search" class="layui-btn" lay-submit><i class="fa fa-search" aria-hidden="true"></i> 查询</button>
                        </div>
                    </div>
                </div>
            </blockquote>

			<fieldset class="layui-elem-field">
				<legend>JS店铺列表</legend>
				&nbsp;&nbsp;&nbsp;&nbsp;
<#--				<button type="button" class="layui-btn layui-btn-small" id="auditBtn">审核</button>-->
<#--				<button type="button" class="layui-btn layui-btn-small layui-btn-normal" id="detailBtn">详情</button>-->
				<button type="button" class="layui-btn layui-btn-small layui-btn-warm" id="failureRepeatBtn">重推</button>
<#--				<button type="button" class="layui-btn layui-btn-small layui-btn-danger" id="fxqBtn">反洗钱信息</button>-->
				<div class="layui-field-box layui-form">
					<table class="layui-table admin-table" style="table-layout:fixed;word-wrap:break-word;">
						<thead>
							<tr>
								<th style="width: 20px;"></th>
								<th>店铺名称</th>
								<th>所在平台</th>
								<th>所在站点</th>
								<th>店铺情况</th>
								<th>店铺网址</th>
								<th>授权状态</th>
								<th>处理状态</th>
								<th>创建时间</th>
								<th>更新时间</th>
							</tr>
						</thead>
						<tbody id="kycStoreContent">
						</tbody>
					</table>
				</div>
			</fieldset>
			<div class="admin-table-page">
				<div id="paged" class="page">
				</div>
			</div>
		</div>
		<!--模板-->
		<script type="text/html" id="kycStoreTemplate">
			{{# layui.each(d.list, function(index, item){ }}
			<tr>
				<td><input type="radio" style="display: table" name="kycStoreIdRadio" data-id="{{ item.id }}"></td>
				<td>{{ item.storeName}}</td>
				<td>{{ item.storePlateformName }}</td>
				<td>{{ item.storeTheSiteName }}</td>
				<td>{{ item.storeSituationDesc }}</td>
				<td>{{ item.storeUrl }}</td>
				<td>{{ convertAuthStatusDesc(item.authStatus) }}</td>
				<td>{{ item.processStatusDesc }}</td>
				<td>{{ item.createDtsStr }}</td>
				<td>{{ item.updateDtsStr }}</td>
			</tr>
			{{# }); }}
		</script>
		<script type="text/javascript" src="../../../../plugins/layui/layui.js"></script>
		<script>
			layui.config({
				base: '../../../../js/'
			});
			layui.use(['paging', 'form'], function() {
				var $ = layui.jquery,
					paging = layui.paging(),
					layerTips = parent.layer === undefined ? layui.layer : parent.layer, //获取父窗口的layer对象
					layer = layui.layer, //获取当前窗口的layer对象
					form = layui.form();

                paging.init({
                    openWait: true,
					url: '/api/v1/anon/jsKycStore/getKycStoreList?v=' + new Date().getTime(), //地址
					elem: '#kycStoreContent', //内容容器
					params: {
						processStatus : "TRADE_UNPROCESSED"
					},
					type: 'GET',
					tempElem: '#kycStoreTemplate', //模块容器
					pageConfig: { //分页参数配置
						elem: '#paged', //分页容器
						pageSize: 10 //分页大小
					},
					success: function(a,b,c,d) { //渲染成功的回调
						//alert('渲染成功');
					},
					fail: function(msg) { //获取数据失败的回调
						//alert('获取数据失败')
					},
					complate: function() { //完成的回调
						console.log("加载完成");
					},
				});

				$('#search').on('click', function() {
                    var processStatus = $("#processStatus").val();
                    var storeName = $("#storeName").val();
                    paging.get({
                        "processStatus": processStatus,
                        "storeName":storeName,
                        "v":new Date().getTime()
                    });
				});

				//重推操作按钮监听事件
				$('#failureRepeatBtn').on('click', function() {
					var isChecked = false;
					$('#kycStoreContent').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							isChecked = true;
							var dataId = $cbxDom.getAttribute("data-id");
							if(undefined == dataId || null == dataId || '' == dataId){
								layer.msg('请选中操作行');
								return;
							}
							kycStoreRepeatToXH(dataId);
							return;
						}
					});
					if(!isChecked){
						layer.msg('请选中操作行');
					}
				});

				function kycStoreRepeatToXH(kycStoreId) {
					layer.confirm('此操作为店铺执行失败操作,确定要执行么？(请不要重复点击,卡顿属于正常现象)',
						{icon: 0, title: '提示'},
						function (index) {
							$.post("/api/v1/anon/jsKycStore/repeatToXh",{kycStoreId : kycStoreId},function(result){
								if (result.success == true) {
									layerTips.msg('执行成功');
									layerTips.close(index);
									location.reload(); //刷新
								} else {
									layerTips.msg(result.msg);
								}
							});
						},function (index){
							layer.close(index);
						}
					);
				}
			});
			function convertAuthStatusDesc(authStatus) {
				if ("0" == authStatus) {
					return "未授权";
				} else if ("1" == authStatus) {
					return "已经授权但调用失败";
				} else if ("2" == authStatus) {
					return "已经授权但没有确认第一笔回款";
				} else if ("3" == authStatus) {
					return "已授权且收到了回款";
				} else if ("4" == authStatus) {
					return "授权被取消";
				} else {
					return "系统数据异常"
				}
			}
		</script>
	</body>
</html>