﻿<!DOCTYPE html>
<html>

	<head>
		<meta charset="UTF-8">
		<title>入账管理</title>
		<link rel="stylesheet" href="../../../../plugins/layui/css/layui.css" media="all" />
		<link rel="stylesheet" href="../../../../css/global.css" media="all">
		<link rel="stylesheet" href="../../../../plugins/font-awesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../../../../css/table.css" />
		<link rel="stylesheet" href="../../../../css/custom.css" />
	</head>

	<body>
		<div class="admin-main">
            <blockquote class="layui-elem-quote" style="height: 30px">
                <div class="layui-form" style="float:right;">
                    <div class="layui-form-item">
                        <label class="layui-form-label">店铺名称</label>
                        <div class="layui-input-inline" style="width:150px;">
							<input type="text" name="storeName" id="storeName" autocomplete="off" class="layui-input">
                        </div>
                        <label class="layui-form-label" style="width: 100px">处理状态</label>
                        <div class="layui-input-inline">
                            <select name="processStatusEnum" id="processStatusEnum" lay-search="">
                                <option value="TRADE_UNPROCESSED">未处理</option>
                                <option value="TRADE_PROCESSED" >已处理</option>
                                <option value="TRADE_PROCESSEDING" selected>处理中(未入账)</option>
                            </select>
                        </div>
                        <div class="layui-form-mid layui-word-aux" style="padding:0;">
                            <button id="search" lay-filter="search" class="layui-btn" lay-submit><i class="fa fa-search" aria-hidden="true"></i> 查询</button>
                        </div>
                    </div>
                </div>
            </blockquote>

			<fieldset class="layui-elem-field">
				<legend>入账列表</legend>
				&nbsp;&nbsp;&nbsp;&nbsp;
				<button type="button" class="layui-btn layui-btn-small" id="tradeInProcessBtn">入账处理</button>
				<button type="button" class="layui-btn layui-btn-small" id="tradeNotInProcessBtn">无需入账处理</button>
				<div class="layui-field-box layui-form">
					<table class="layui-table admin-table" style="table-layout:fixed;word-wrap:break-word;">
						<thead>
							<tr>
								<th style="width: 20px;"><input type="checkbox" lay-filter="allselector" lay-skin="primary"></th>
								<th>入账时间</th>
								<th>店铺名称</th>
								<th>入账通知编号</th>
								<th>入账币种</th>
								<th>入账金额</th>
								<th>处理状态</th>
							</tr>
						</thead>
						<tbody id="content">
						</tbody>
					</table>
				</div>
			</fieldset>
			<div class="admin-table-page">
				<div id="paged" class="page">
				</div>
			</div>
		</div>
		<!--模板-->
		<script type="text/html" id="tpl">
			{{# layui.each(d.list, function(index, item){ }}
			<tr>
				<td><input type="checkbox" lay-skin="primary" data-id="{{ item.tradeId }}"></td>
				<td>{{ item.tradeDtsStr }}</td>
				<td>{{ item.storeName }}</td>
				<td>{{ item.transinNoticeId }}</td>
				<td>{{ item.currency }}</td>
				<td>{{ item.amt }}</td>
				<td>{{ convertProcessStatus(item.processStatus) }}</td>
			</tr>
			{{# }); }}
		</script>
		<script type="text/javascript" src="../../../../plugins/layui/layui.js"></script>
		<script>
			layui.config({
				base: '../../../../js/'
			});
			layui.use(['paging', 'form'], function() {
				var $ = layui.jquery,
					paging = layui.paging(),
					layerTips = parent.layer === undefined ? layui.layer : parent.layer, //获取父窗口的layer对象
					layer = layui.layer, //获取当前窗口的layer对象
					form = layui.form();

                paging.init({
                    openWait: true,
					url: '/api/v1/anon/jsPayTrade/getPayTradeInList', //地址
					elem: '#content', //内容容器
					params: { //发送到服务端的参数
						processStatusEnum : 'TRADE_PROCESSEDING'
					},
					type: 'GET',
					tempElem: '#tpl', //模块容器
					pageConfig: { //分页参数配置
						elem: '#paged', //分页容器
						pageSize: 10 //分页大小
					},
					success: function(a,b,c,d) { //渲染成功的回调
						//alert('渲染成功');
					},
					fail: function(msg) { //获取数据失败的回调
						//alert('获取数据失败')
					},
					complate: function() { //完成的回调
						console.log("数据加载完成");
						form.render('checkbox');
						form.on('checkbox(allselector)', function(data) {
							var elem = data.elem;
							$('#content').children('tr').each(function() {
								var $that = $(this);
								//全选或反选
								$that.children('td').eq(0).children('input[type=checkbox]')[0].checked = elem.checked;
								form.render('checkbox');
							});
						});
					},
				});

				$('#search').on('click', function() {
                    var processStatusEnum = $("#processStatusEnum").val();
                    var storeName = $("#storeName").val();
                    paging.get({
                        "processStatusEnum": processStatusEnum,
                        "storeName":storeName,
                        "v":new Date().getTime()
                    });
				});

				//入账处理操作
				$('#tradeInProcessBtn').on('click', function() {
					var processStatusEnum = $("#processStatusEnum").val();
					if('TRADE_PROCESSEDING' != processStatusEnum){
						layer.msg('请筛选正确状态数据进行处理');
						return;
					}
					var arr = new Array();
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=checkbox]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							var tradeId = $cbxDom.getAttribute("data-id");
							arr.push(tradeId);
						}
					});
					if(arr.length < 1){
						layer.msg('请选择需要处理的数据行');
					}else{
						processForm(arr);
					}
				});

				//无需入账处理操作
				$('#tradeNotInProcessBtn').on('click', function() {
					var processStatusEnum = $("#processStatusEnum").val();
					if('TRADE_PROCESSEDING' != processStatusEnum){
						layer.msg('请筛选正确状态数据进行处理');
						return;
					}
					var arr = new Array();
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=checkbox]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							var tradeId = $cbxDom.getAttribute("data-id");
							arr.push(tradeId);
						}
					});
					if(arr.length < 1){
						layer.msg('请选择需要处理的数据行');
					}else{
						processNotInForm(arr);
					}
				});

				function processNotInForm(arr) {
					layer.prompt({
						formType: 2,
						value: '',
						title: '请输入处理备注(此操作为不需要入账处理,请谨慎操作)',
						area: ['400px', '200px'] //自定义文本域宽高
					}, function(value, index, elem){
						$.post("/api/v1/anon/jsPayTrade/tradeNotInProcess",{tradeIds : arr.toString(),remark : value},function(result){
							if (result.success == true) {
								layerTips.msg('执行成功');
								layer.close(index);
								location.reload(); //刷新
							} else {
								layerTips.msg(result.msg);
							}
						});
					});
				}

				function processForm(arr) {
					layer.prompt({
						formType: 2,
						value: '',
						title: '请输入处理备注',
						area: ['400px', '200px'] //自定义文本域宽高
					}, function(value, index, elem){
						$.post("/api/v1/anon/jsPayTrade/tradeInProcess",{tradeIds : arr.toString(),remark : value},function(result){
							if (result.success == true) {
								layerTips.msg('执行成功');
								layer.close(index);
								location.reload(); //刷新
							} else {
								layerTips.msg(result.msg);
							}
						});
					});
				}
			});
			function convertProcessStatus(processStatus) {
				if ("TRADE_UNPROCESSED" == processStatus) {
					return "未处理";
				} else if ("TRADE_PROCESSED" == processStatus) {
					return "已处理";
				} else if ("TRADE_PROCESSEDING" == processStatus) {
					return "处理中(未入账)";
				} else {
					return "系统数据异常"
				}
			}
		</script>
	</body>

</html>