package com.js.manage.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiSunrateBeneficiaryService;
import com.js.common.constant.Constant;
import com.js.common.enums.CertiStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.KycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class KycSunrateBeneficiaryServiceImpl implements KycSunrateBeneficiaryService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiSunrateBeneficiaryService apiSunrateBeneficiaryService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    private ApiKycNaturalService apiKycNaturalService;


    @Override
    public String getKycSunrateBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq) {
        return apiSunrateBeneficiaryService.getKycSunrateBeneficiary(kycSunrateBeneficiaryReq);
    }

    @Override
    public ResponseMessage addKycSunrateBeneficiaryFromSys(String jsPaySysAcctId,String kycNautralId) {
        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(kycNautralId);
        if(null == kycNaturalVO){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到KYC信息,kycNaturalId: " + kycNautralId);
        }
        CertiStatusEnum certiStatusEnum = kycNaturalVO.getCertificationStatus();
        if(CertiStatusEnum.NO_SUBMIT.equals(certiStatusEnum) || CertiStatusEnum.KYC_INFO_SUBMIT.equals(certiStatusEnum)
                || CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(certiStatusEnum)
                || CertiStatusEnum.SUBMIT_FIRST_TRIAL.equals(certiStatusEnum)
                || CertiStatusEnum.SUBMIT_FAILURE.equals(certiStatusEnum)){
            log.error("KYC用户当前状态不正确:{}" , certiStatusEnum);
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"KYC用户当前状态不正确");
        }
        kycNaturalVO.setJsPaySysAcctId(jsPaySysAcctId);
        kycNaturalVO.setOrgCode(kycNaturalVO.getIdNo());
        return apiSunrateBeneficiaryService.beneficiaryCreateMQ(kycNaturalVO);
    }

    @Override
    public ResponseMessage addFailureKycSunrateBeneficiary(String failureMsg,String kycNaturalId) {
        if(StringUtils.isBlank(failureMsg)){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),"内容不能为空");
        }
        if(StringUtils.isBlank(kycNaturalId)){
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR.getCode(),"请选择需要补充受益人记录");
        }
        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(kycNaturalId);
        if(null == kycNaturalVO){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"未查询到KYC信息,kycNaturalId: " + kycNaturalId);
        }
        try{
            CertiStatusEnum certiStatusEnum = kycNaturalVO.getCertificationStatus();
            if(CertiStatusEnum.NO_SUBMIT.equals(certiStatusEnum) || CertiStatusEnum.KYC_INFO_SUBMIT.equals(certiStatusEnum)
                    || CertiStatusEnum.FIRST_TRIAL_FAILURE.equals(certiStatusEnum)
                    || CertiStatusEnum.SUBMIT_FIRST_TRIAL.equals(certiStatusEnum)
                    || CertiStatusEnum.SUBMIT_FAILURE.equals(certiStatusEnum)){
                log.error("KYC用户当前状态不正确:{}" , certiStatusEnum);
                return ResultUtil.error(ResultEnum.ERROR.getCode(),"KYC用户当前状态不正确");
            }
            JSONObject jsonObject = JSONObject.parseObject(failureMsg);
            KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq = jsonObject.toJavaObject(KycSunrateBeneficiaryReq.class);
            return apiSunrateBeneficiaryService.beneficiaryCreate(kycSunrateBeneficiaryReq,kycNaturalVO);
        }catch (Exception ex){
            log.error("处理异常:",ex);
        }
        return ResultUtil.success(ResultEnum.ERROR);
    }
}
