package com.js.manage.service.impl;

import com.js.api.jspay.service.ApiJsPaySunrateBankService;
import com.js.api.jspay.service.ApiJsPaySunrateBankTradeInService;
import com.js.common.constant.Constant;
import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsPaySunrateBankTradeInReq;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.vo.JsPaySunrateBankVO;
import com.js.common.model.vo.JsTradeListVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsPayTradeService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
@Slf4j
public class JsPayTradeServiceImpl implements JsPayTradeService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    ApiJsPaySunrateBankTradeInService apiJsPaySunrateBankTradeInService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            timeout = 60000,
            retries = 0
    )
    private ApiJsPaySunrateBankService apiJsPaySunrateBankService;

    @Override
    public String getPayTradeInList(JsTradeListReq jsTradeListReq) {
        return apiJsPaySunrateBankTradeInService.manageTradeInList(jsTradeListReq);
    }

    @Override
    public ResponseMessage tradeInProcess(String tradeIds,String remark){
        JsTradeListReq jsTradeListReq = new JsTradeListReq();
        jsTradeListReq.setId(tradeIds);
        List<JsTradeListVO> jsTradeListVOList = apiJsPaySunrateBankTradeInService.tradeInListNoPage(jsTradeListReq,null);
        int totalCount = jsTradeListVOList.size();
        int successCount = 0;
        int failureCount = 0;
        for(JsTradeListVO jsTradeListVO : jsTradeListVOList){
            log.info("更新账户余额开始:{}",jsTradeListVO);
            try {
                JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq = new JsPaySunrateBankTradeInReq();
                jsPaySunrateBankTradeInReq.setTransinAmt(jsTradeListVO.getAmt());
                jsPaySunrateBankTradeInReq.setTransinNoticeId(jsTradeListVO.getTransinNoticeId());
                jsPaySunrateBankTradeInReq.setRemark(remark);
                JsPaySunrateBankVO jsPaySunrateBankVO = new JsPaySunrateBankVO();
                jsPaySunrateBankVO.setId(jsTradeListVO.getSunrateBankId());
                jsPaySunrateBankVO.setCurrentBalance(jsTradeListVO.getCurrentBalance());
                jsPaySunrateBankVO.setAvailableBalance(jsTradeListVO.getAvailableBalance());
                ResponseMessage updateVirtualAmtResponse = apiJsPaySunrateBankService.updateVirtualAmt(jsPaySunrateBankTradeInReq, jsPaySunrateBankVO);
                log.info("更新账户余额结束,返回结果:{}", updateVirtualAmtResponse);
                if(updateVirtualAmtResponse.isSuccess()){
                    successCount = successCount + 1;
                }else{
                    failureCount = failureCount + 1;
                }
            }catch (Exception ex){
                failureCount = failureCount + 1;
                log.error("处理待入账交易失败:",ex);
            }
        }
        if(totalCount == successCount) {
            return ResultUtil.success(ResultEnum.SUCCESS);
        }else{
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"总执行条数：" + totalCount + ";成功条数：" + successCount + ";失败条数：" + failureCount);
        }
    }

    @Override
    public ResponseMessage tradeNotInProcess(String tradeIds,String remark){
        String[] ids = tradeIds.split(",");
        int successCount = 0;
        for(String id : ids){
            JsPaySunrateBankTradeInReq jsPaySunrateBankTradeInReq = new JsPaySunrateBankTradeInReq();
            jsPaySunrateBankTradeInReq.setId(id);
            jsPaySunrateBankTradeInReq.setRemark(remark);
            jsPaySunrateBankTradeInReq.setProcessStatusEnum(ProcessStatusEnum.TRADE_PROCESSED);
            int updateCount = apiJsPaySunrateBankTradeInService.updateJsPaySunrateBankTradeIn(jsPaySunrateBankTradeInReq);
            successCount = successCount + updateCount;
        }
        if(ids.length == successCount){
            return ResultUtil.success(ResultEnum.SUCCESS);
        }else{
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"处理总条数：" + ids.length + ";成功条数：" + successCount);
        }
    }
}
