package com.js.manage.controller;

import com.js.common.constant.Constant;
import com.js.common.model.req.JsPaySunrateQueryPriceTradeCreateReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.manage.service.JsPaySunrateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author liuh
 * @Description 寻汇
 * @Date 2019/8/27
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
public class JsPaySunrateController {
    @Autowired
    JsPaySunrateService jsPaySunrateService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPaySunrate/queryPrice.html")
    public String toQueryPricePage() {
        return "js_pay_sunrate/query_price";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPaySunrate/queryPriceProcess")
    @ResponseBody
    public ResponseMessage queryPriceProcess(JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq) {
        return jsPaySunrateService.queryPriceProcess(jsPaySunrateQueryPriceTradeCreateReq);
    }
}
