package com.js.manage.controller;

import cn.hutool.json.JSONUtil;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsPaySysAcctReq;
import com.js.manage.service.JsPaySysAcctService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author liuh
 * @Description 平台三方账户管理
 * @Date 2019/8/23
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class JsPaySysAcctController {

    @Autowired
    JsPaySysAcctService jsPaySysAcctService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPaySysAcct/list.html")
    public String listInput() {
        return "js_pay_sysacct/list";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsPaySysAcct/getJsPaySysAcctList" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getJsPaySysAcctList(JsPaySysAcctReq jsPaySysAcctReq) {
        return JSONUtil.parseObj(jsPaySysAcctService.getJsPaySysAcctList(jsPaySysAcctReq));
    }
}
