package com.js.manage.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.api.jspay.service.ApiKycStoreService;
import com.js.api.jspay.service.ApiKycSunrateStoreService;
import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.Constant;
import com.js.common.enums.ProcessStatusEnum;
import com.js.common.enums.ResultEnum;
import com.js.common.enums.StorePlateformEnum;
import com.js.common.model.req.KycStoreEditReq;
import com.js.common.model.req.KycStoreReq;
import com.js.common.model.req.KycSunrateStoreReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.KycStoreVO;
import com.js.common.model.vo.KycSunrateStoreVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycStoreService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class JsKycStoreServiceImpl implements JsKycStoreService {
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiKycStoreService apiKycStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiKycSunrateStoreService apiKycSunrateStoreService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiSunrateTradePriceService apiSunrateTradePriceService;
    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    private ApiKycNaturalService apiKycNaturalService;

    @Override
    public String getKycStoreList(KycStoreReq kycStoreReq){
        return apiKycStoreService.storeListYY(kycStoreReq);
    }

    @Override
    public ResponseMessage kycStoreRepeatToXH(String kycStoreId) {
        KycStoreVO kycStoreVO = apiKycStoreService.findKycStoreByPrimaryKey(kycStoreId, null);
        ProcessStatusEnum processStatus = kycStoreVO.getProcessStatus();
        if(ProcessStatusEnum.TRADE_PROCESSED.equals(processStatus)){
            return ResultUtil.error(ResultEnum.STATUS_NOT_CORRECT.getCode(),"店铺" + ResultEnum.STATUS_NOT_CORRECT.getMsg());
        }
        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(kycStoreVO.getKycNaturalId());
        if(null == kycNaturalVO || StringUtils.isBlank(kycNaturalVO.getId())){
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST.getCode(),"根据店铺存储kycNaturalId未查询到用户信息入参：" + kycStoreVO.getKycNaturalId());
        }
        String orgCode = apiSunrateTradePriceService.findOrgCode(kycNaturalVO.getId(),kycNaturalVO.getRegisterType());
        if(StringUtils.isBlank(orgCode)){
            return ResultUtil.error(ResultEnum.MESSAGE_NOT_EXIST.getCode(),"未查询到orgCode");
        }
        KycSunrateStoreReq kycSunrateStoreReq = new KycSunrateStoreReq();
        kycSunrateStoreReq.setOrgCode(orgCode);
        if(null != kycStoreVO.getStoreTheSite()){
            kycSunrateStoreReq.setCurId(kycStoreVO.getStoreTheSite().getCurrency());
        }
        kycSunrateStoreReq.setStoreName(kycStoreVO.getStoreName());
        if(kycStoreVO.getStoreSituation()) {
            kycSunrateStoreReq.setStoreUrl(kycStoreVO.getStoreUrl());
        }
        kycSunrateStoreReq.setStorePlateform(StorePlateformEnum.valueOf(kycStoreVO.getStorePlateformCode()).getCode());
        if(StringUtils.isNotBlank(kycStoreVO.getSellId())){
            kycSunrateStoreReq.setSellerId(kycStoreVO.getSellId());
        }
        KycSunrateStoreVO kycSunrateStoreVO = apiKycSunrateStoreService.findSunrateStoreInfo(kycStoreVO.getId(),"",kycStoreVO.getKycNaturalId());
        if(null == kycSunrateStoreVO){
            kycSunrateStoreReq.setStoreTheSite(kycStoreVO.getStoreTheSite());
            ResponseMessage responseMessage = apiKycSunrateStoreService.sendSunrateStoreInfoToXh("127.0.0.1", kycSunrateStoreReq);
            log.info("请求寻汇公共方法添加店铺信息-结束，请求结果：{}，返回信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            String subAcctNo = jsonObject.getString("subAcctNo");
            String storeName = jsonObject.getString("storeName");
            kycSunrateStoreReq.setKycStoreId(kycStoreId);
            kycSunrateStoreReq.setSubAcctNo(subAcctNo);
            kycSunrateStoreReq.setStoreName(storeName);
            kycSunrateStoreReq.setStoreTheSite(kycStoreVO.getStoreTheSite());
            log.info("保存请求寻汇添加店铺信息-开始");
            ResponseMessage responseMessage1 = apiKycSunrateStoreService.addSunrateStore(kycSunrateStoreReq, kycNaturalVO);
            log.info("保存请求寻汇添加店铺信息-结束，请求结果：{}，返回信息:{}",responseMessage1.isSuccess(),responseMessage1.getMsg());
        }else{
            kycSunrateStoreReq.setStoreTheSite(kycStoreVO.getStoreTheSite());
            kycSunrateStoreReq.setSubAcctNo(kycSunrateStoreVO.getSubAcctNo());
            ResponseMessage responseMessage = apiKycSunrateStoreService.sendEditStoreInfoToXh(kycSunrateStoreReq);
            if(!responseMessage.isSuccess()){
                return responseMessage;
            }
            JSONObject jsonObject = JSONObject.parseObject(JSON.toJSONString(responseMessage.getData()));
            String storeName = jsonObject.getString("storeName");
            kycSunrateStoreReq.setStoreName(storeName);
            apiKycSunrateStoreService.updateSunrateStore(kycSunrateStoreReq,kycNaturalVO);
        }
        KycStoreEditReq kycStoreEditReq = new KycStoreEditReq();
        kycStoreEditReq.setKycStoreId(kycStoreId);
        kycStoreEditReq.setProcessStatus(ProcessStatusEnum.TRADE_PROCESSED);
        ResponseMessage responseMessage = apiKycStoreService.editStoreProcessStatus(kycStoreEditReq, kycNaturalVO);
        return responseMessage;
    }
}
