package com.js.manage.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.json.JSONUtil;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.KycStoreReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycStoreService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 *
 * @Author liuh
 * @Description 店铺
 * @Date 2019/8/26
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class JsKycStoreController {

    @Autowired
    JsKycStoreService jsKycStoreService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycStore/list.html")
    public String listInput() {
        return "kyc_store/list";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsKycStore/getKycStoreList" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getKycStoreList(KycStoreReq kycStoreReq) {
        return JSONUtil.parseObj(jsKycStoreService.getKycStoreList(kycStoreReq));
    }

    @PostMapping(value = Constant.ApiLoginAuth.ANON  + "/jsKycStore/repeatToXh")
    @ResponseBody
    public ResponseMessage repeatToXh(String kycStoreId) {
        log.info("运营平台重新推送店铺信息到寻汇操作开始：kycStoreId:{}",kycStoreId);
        if(ObjectUtil.isNotEmpty(kycStoreId)) {
            return jsKycStoreService.kycStoreRepeatToXH(kycStoreId);
        }else {
            return ResultUtil.error(ResultEnum.NO_MUST_PARAM_ERROR);
        }
    }
}
