package com.js.manage.controller;

import com.js.common.constant.Constant;
import com.js.manage.service.JsFileSerivce;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.tomcat.util.http.fileupload.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/**
 * @Author yjzhao
 * @Description 文件操作
 * @Date 2019/5/18 20:36
 * @Param 
 * @return 
 **/
@RestController
@RequestMapping(value = Constant.ApiPath.V1,
        produces = {MediaType.APPLICATION_JSON_UTF8_VALUE})
@Slf4j
public class JsFileController {

    @Autowired
    private JsFileSerivce jsFileSerivce;

    /**
     * 下载文件
     * @return
     */
    @GetMapping(value = Constant.ApiLoginAuth.ANON +"/jsFile/downLoad")
    public void downLoad(String filePath,String fileName,HttpServletResponse response) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        if(StringUtils.isBlank(filePath)){
            return;
        }
        try{
            inputStream =  jsFileSerivce.findFile(filePath);
            outputStream = response.getOutputStream();
            response.setContentType("application/x-download");
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(fileName.getBytes("gbk"), "iso8859-1"));
            IOUtils.copy(inputStream, outputStream);
            outputStream.flush();
        }catch (IOException ioe){
            log.error("下载文件异常",ioe);
        }finally {
            IOUtils.closeQuietly(inputStream);
            IOUtils.closeQuietly(outputStream);
        }
    }
}
