﻿<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title>寻汇入账管理</title>
		<link rel="stylesheet" href="../../../../plugins/layui/css/layui.css" media="all" />
		<link rel="stylesheet" href="../../../../css/global.css" media="all">
		<link rel="stylesheet" href="../../../../plugins/font-awesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../../../../css/table.css" />
		<link rel="stylesheet" href="../../../../css/custom.css" />
	</head>
	<body>
		<form class="layui-form">
			<div class="layui-form-item">
				<label class="layui-form-label">queryNo</label>
				<div class="layui-input-block">
					<input type="text" id="queryNo" name="queryNo" autocomplete="off" class="layui-input">
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">orgCode</label>
				<div class="layui-input-block">
					<input type="text" id="orgCode" name="orgCode" autocomplete="off" class="layui-input">
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">buyCur</label>
				<div class="layui-input-block">
					<input type="text" id="buyCur" name="buyCur" autocomplete="off" class="layui-input">
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">sellCur</label>
				<div class="layui-input-block">
					<input type="text" id="sellCur" name="sellCur" autocomplete="off" class="layui-input">
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">txnMode</label>
				<div class="layui-input-block">
					<input type="text" id="txnMode" name="txnMode" autocomplete="off" class="layui-input">
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">txnAmt</label>
				<div class="layui-input-block">
					<input type="text" id="txnAmt" name="txnAmt" autocomplete="off" class="layui-input">
				</div>
			</div>
			<div class="layui-form-item">
				<div class="layui-input-block">
					<button class="layui-btn" lay-submit="" lay-filter="submitBtn">立即提交</button>
					<button type="reset" class="layui-btn layui-btn-primary">重置</button>
				</div>
			</div>

			<fieldset class="layui-elem-field layui-field-title">
				<legend>寻汇返回查询结果</legend>
			</fieldset>
			<div class="layui-form-item">
				<label class="layui-form-label">买入金额</label>
				<div class="layui-input-block">
					<input type="text" id="txnBuyAmtDeal" autocomplete="off" class="layui-input" readonly>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">卖出金额</label>
				<div class="layui-input-block">
					<input type="text" id="txnSellAmtDeal" autocomplete="off" class="layui-input" readonly>
				</div>
			</div>
			<div class="layui-form-item">
				<label class="layui-form-label">成交汇率</label>
				<div class="layui-input-block">
					<input type="text" id="txnQueryRateDeal" autocomplete="off" class="layui-input" readonly>
				</div>
			</div>
		</form>


		<script type="text/javascript" src="../../../../plugins/layui/layui.js"></script>
		<script>
			layui.config({
				base: '../../../../js/'
			});
			layui.use(['form'], function() {
				var $ = layui.jquery,
				layerTips = parent.layer === undefined ? layui.layer : parent.layer, //获取父窗口的layer对象
				layer = layui.layer, //获取当前窗口的layer对象
				form = layui.form();

				form.on('submit(submitBtn)', function(data) {
					$.ajax({
						type: "GET",
						url: "/api/v1/anon/jsPaySunrate/queryPriceProcess",
						data: data.field,
						success: function(result){
							if(result.success == true) {
								layerTips.msg("查询成功");
								console.log(result);
								$("#txnBuyAmtDeal").val(result.data.buyAmt);
								$("#txnSellAmtDeal").val(result.data.sellAmt);
								$("#txnQueryRateDeal").val(result.data.queryRate);
							}else {
								layerTips.msg(result.msg);
							}
						}
					});
					return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
				});
			});
		</script>
	</body>
</html>