package com.js.manage.service.impl;

import com.js.api.jspay.service.ApiJsPaySysAcctService;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsPaySysAcctReq;
import com.js.manage.service.JsPaySysAcctService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class JsPaySysAcctServiceImpl implements JsPaySysAcctService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiJsPaySysAcctService apiJsPaySysAcctService;

    @Override
    public String getJsPaySysAcctList(JsPaySysAcctReq jsPaySysAcctReq){
        return apiJsPaySysAcctService.getJsPaySysAcctList(jsPaySysAcctReq);
    }
}
