package com.js.manage.service.impl;

import com.js.api.jspay.service.ApiSunrateTradePriceService;
import com.js.common.constant.CommonConstant;
import com.js.common.constant.Constant;
import com.js.common.model.req.JsPaySunrateQueryPriceTradeCreateReq;
import com.js.common.model.req.SunrateTradePriceReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.manage.service.JsPaySunrateService;
import lombok.extern.slf4j.Slf4j;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class JsPaySunrateServiceImpl implements JsPaySunrateService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 30000
    )
    ApiSunrateTradePriceService apiSunrateTradePriceService;

    @Override
    public ResponseMessage queryPriceProcess(JsPaySunrateQueryPriceTradeCreateReq jsPaySunrateQueryPriceTradeCreateReq){
        SunrateTradePriceReq sunrateTradePriceReq = new SunrateTradePriceReq();
        sunrateTradePriceReq.setOrgCode(jsPaySunrateQueryPriceTradeCreateReq.getOrgCode());
        sunrateTradePriceReq.setBuyCur(jsPaySunrateQueryPriceTradeCreateReq.getBuyCur());
        sunrateTradePriceReq.setSellCur(jsPaySunrateQueryPriceTradeCreateReq.getSellCur());
        sunrateTradePriceReq.setTxnMode(CommonConstant.TXN_MODE_SELL);
        sunrateTradePriceReq.setTxnAmt(jsPaySunrateQueryPriceTradeCreateReq.getTxnAmt());
        sunrateTradePriceReq.setBrowserIP("127.0.0.1");
        ResponseMessage responseMessage = apiSunrateTradePriceService.xhTradeQueryPrice(sunrateTradePriceReq);
        log.info("寻汇-询价结束-返回结果:{},描述信息:{}",responseMessage.isSuccess(),responseMessage.getMsg());
        return responseMessage;
    }
}
