package com.js.manage.service.impl;

import com.js.api.jspay.service.*;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.*;
import com.js.common.model.vo.KycDictionaryVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycDictionaryService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class JsKycDictionaryServiceImpl implements JsKycDictionaryService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}",
            retries = 0,
            timeout = 60000
    )
    ApiKycDictionaryService apiKycDictionaryService;

    @Override
    public String getKycDictionaryRootList(KycDictionaryReq kycDictionaryReq){
        return apiKycDictionaryService.getKycDictionaryRootList(kycDictionaryReq);
    }

    @Override
    public ResponseMessage operateKycDictionary(KycDictionaryReq kycDictionaryReq) {
        int operateCount = 0;
        if(StringUtils.isBlank(kycDictionaryReq.getId())){
            operateCount = apiKycDictionaryService.addKycDictionary(kycDictionaryReq);
        }else{
            operateCount = apiKycDictionaryService.updateKycDictionary(kycDictionaryReq);
        }
        if(operateCount == 0){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"操作失败");
        }
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public ResponseMessage operateKycDictionaryRoot(KycDictionaryReq kycDictionaryReq) {
        int operateCount = 0;
        if(StringUtils.isBlank(kycDictionaryReq.getId())){
            kycDictionaryReq.setSort(0);
            kycDictionaryReq.setAvailableFlag(true);
            operateCount = apiKycDictionaryService.addKycDictionary(kycDictionaryReq);
        }else{
            operateCount = apiKycDictionaryService.updateKycDictionary(kycDictionaryReq);
        }
        if(operateCount == 0){
            return ResultUtil.error(ResultEnum.ERROR.getCode(),"操作失败");
        }
        log.info("操作条数：{}",operateCount);
        return ResultUtil.success(ResultEnum.SUCCESS);
    }

    @Override
    public KycDictionaryVO getKycDictionary(String id) {
        return apiKycDictionaryService.getDictionary(id);
    }
}
