package com.js.manage.controller;

import cn.hutool.json.JSONUtil;
import com.js.common.constant.Constant;
import com.js.common.model.req.KycSunrateBeneficiaryReq;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.manage.service.KycSunrateBeneficiaryService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author liuh
 * @Description KYC受益人管理
 * @Date 2019/8/25
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
@Slf4j
public class KycSunrateBeneficiaryController {

    @Autowired
    KycSunrateBeneficiaryService kycSunrateBeneficiaryService;

//    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPaySysAcct/list.html")
//    public String listInput() {
//        return "js_pay_sysacct/list";
//    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/kycSunrateBeneficiary/getKycSunrateBeneficiary" ,produces = "text/html;charset=UTF-8")
    @ResponseBody
    public Object getKycSunrateBeneficiary(KycSunrateBeneficiaryReq kycSunrateBeneficiaryReq) {
        return JSONUtil.parseObj(kycSunrateBeneficiaryService.getKycSunrateBeneficiary(kycSunrateBeneficiaryReq));
    }

    /**
     * @Author liuh
     * @Description 根据已预置受益人数据为KYC添加受益人
     * @Date 2019/8/25
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON  + "/kycSunrateBeneficiary/addKycSunrateBeneficiaryFromSys")
    @ResponseBody
    public ResponseMessage addKycSunrateBeneficiaryFromSys(String jsPaySysAcctId,String kycNaturalId) {
        log.info("根据已预置受益人数据为KYC添加受益人：jsPaySysAcctId:{},kycNaturalId:{}",jsPaySysAcctId,kycNaturalId);
        return kycSunrateBeneficiaryService.addKycSunrateBeneficiaryFromSys(jsPaySysAcctId,kycNaturalId);
    }

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/kycSunrateBeneficiary/failureBeneficiaryProcess.html")
    public String failureBeneficiaryProcess() {
        return "kyc_natural/kyc_beneficiary_failure";
    }

    /**
     * @Author liuh
     * @Description 根据失败错误信息重新推送受益人
     * @Date 2019/8/25
     */
    @PostMapping(value = Constant.ApiLoginAuth.ANON  + "/kycSunrateBeneficiary/addFailureKycSunrateBeneficiary")
    @ResponseBody
    public ResponseMessage addFailureKycSunrateBeneficiary(String failureMsg,String kycNaturalId) {
        return kycSunrateBeneficiaryService.addFailureKycSunrateBeneficiary(failureMsg,kycNaturalId);
    }
}
