package com.js.manage.service;

import com.alibaba.fastjson.JSONObject;
import com.js.common.enums.RegisterType;
import com.js.common.model.req.JsKycChargeReq;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.JsKycChargeVO;
import com.js.common.model.vo.KycPasswordVO;
import com.js.common.model.vo.common.ResponseMessage;

import java.util.List;

/**
 * 用户 kyc 信息
 */
public interface JsKycNaturalService {

    /**
     * 获取用户信息列表
     */
    String getKycNaturalList(KycNaturalListReq kycNaturalListReq);

    /**
     * 获取用户详情
     */
    ResponseMessage getKycNatural(String id);

    /**
     * 更新用户信息
     */
    int updateKycNatural(KycNaturalReq kycNaturalReq);

    /**
     * 删除用户信息（逻辑删除）
     */
    int deleteKycNatural(String id);

    /**
     * 获取实名用户详情
     */
    ResponseMessage getKycNaturalDetail(String id, RegisterType registerType);

    /**
     * 获取实名用户详情
     */
    ResponseMessage auditKycNatural(KycNaturalReq kycNaturalReq);

    /**
     * @Author liuh
     * @Description 获取当前用户所有费率信息
     * @Date 2019/8/14
     */
    JSONObject getKycChargeList(String kycNaturalId);

    /**
     * 费率编辑
     */
    ResponseMessage operateKycChargeInfo(JsKycChargeReq jsKycChargeReq);

    ResponseMessage getKycNaturalAntiMoneyInfo(String id);

    /**
     * 反洗钱 审核操作 更新
     * @param id      反洗钱 ID
     * @param certificationStatus
     * @return
     */
    ResponseMessage updateXGServicesStatusById(String id , String certificationStatus);

    /**
     * KYC 反洗钱审核操作 更新
     * @param kycNaturaId  KYC ID
     * @param certificationStatus
     * @return
     */
    ResponseMessage updateKycNaturalStatusById( String kycNaturaId ,String certificationStatus);
}
