package com.js.manage.controller;

import com.js.common.constant.Constant;
import com.js.common.model.req.JsTradeListReq;
import com.js.manage.service.JsPayTradeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @Author liuh
 * @Description 交易管理
 * @Date 2019/7/9
 */
@Controller
@RequestMapping(value = Constant.ApiPath.V1)
public class JsPayTradeController {
    @Autowired
    JsPayTradeService jsPayTradeService;

    @RequestMapping(value = Constant.ApiLoginAuth.ANON  + "/jsPayTrade/tradeInList.html")
    public String toTradeInListPage() {
        return "js_pay_trade/tradeInList";
    }

    @GetMapping(value = Constant.ApiLoginAuth.ANON + "/jsPayTrade/getPayTradeInList")
    @ResponseBody
    public String getPayTradeInList(JsTradeListReq jsTradeListReq) {
        return jsPayTradeService.getPayTradeInList(jsTradeListReq);
    }
}
