﻿<!DOCTYPE html>
<html>
	<head>
		<meta charset="UTF-8">
		<title>商户配置</title>
		<link rel="stylesheet" href="../../../../plugins/layui/css/layui.css" media="all" />
		<link rel="stylesheet" href="../../../../css/global.css" media="all">
		<link rel="stylesheet" href="../../../../plugins/font-awesome/css/font-awesome.min.css">
		<link rel="stylesheet" href="../../../../css/table.css" />
		<link rel="stylesheet" href="../../../../css/custom.css" />
	</head>

	<body>
		<div class="admin-main">
            <blockquote class="layui-elem-quote" style="height: 30px">
                <div class="layui-form" style="float:right;">
                    <div class="layui-form-item">
                        <label class="layui-form-label">实名名称</label>
                        <div class="layui-input-inline" style="width:150px;">
							<input type="text" name="certificationName" id="certificationName" autocomplete="off" class="layui-input">
                        </div>
						<label class="layui-form-label">手机号码</label>
						<div class="layui-input-inline">
                            <input type="text" name="phoneNo" id="phoneNo" autocomplete="off" class="layui-input">
						</div>
                        <label class="layui-form-label" style="width: 100px">实名认证状态</label>
                        <div class="layui-input-inline">
                            <select name="certificationStatus" id="certificationStatus" lay-search="">
								<option value="">请选择</option>
								<option value="NO_SUBMIT" >未提交认证信息</option>
								<option value="SUBMIT_FIRST_TRIAL" selected>提交初审</option>
								<option value="FIRST_TRIAL_FAILURE" >KYC驳回</option>
								<option value="KYC_INFO_SUBMIT" >KYC实名信息提交</option>
								<option value="CONTACTS_AUDIT_FAILURE" >最终受益人驳回</option>
                                <option value="SUBMIT_FAILURE">调用寻汇返回失败</option>
                                <option value="FAILURE" >认证失败</option>
                                <option value="SUCCESS" >已认证</option>
                                <option value="SUBMIT_WATING" >认证审核中</option>
                                <option value="AUDIT_UNKNOWN" >反洗钱未审核</option>
                                <option value="AUDIT_RERUSE" >反洗钱审核拒绝</option>
                            </select>
                        </div>
                        <div class="layui-form-mid layui-word-aux" style="padding:0;">
                            <button id="search" lay-filter="search" class="layui-btn" lay-submit><i class="fa fa-search" aria-hidden="true"></i> 查询</button>
                        </div>
                    </div>
                </div>
            </blockquote>

			<fieldset class="layui-elem-field">
				<legend>商户列表</legend>
				&nbsp;&nbsp;&nbsp;&nbsp;
				<button type="button" class="layui-btn layui-btn-small" id="auditBtn">审核</button>
				<button type="button" class="layui-btn layui-btn-small layui-btn-normal" id="detailBtn">详情</button>
				<button type="button" class="layui-btn layui-btn-small layui-btn-warm" id="kycChargeBtn">收费管理</button>
				<button type="button" class="layui-btn layui-btn-small layui-btn-danger" id="fxqBtn">反洗钱信息</button>
				<button type="button" class="layui-btn layui-btn-small layui-btn-normal" id="kycBeneficiaryBtn">KYC受益人管理</button>
                <button type="button" class="layui-btn layui-btn-small layui-btn-danger" id="failureBeneficiaryProcessBtn">受益人处理</button>
				<div class="layui-field-box layui-form">
					<table class="layui-table admin-table" style="table-layout:fixed;word-wrap:break-word;">
						<thead>
							<tr>
								<th style="width: 20px;"></th>
								<th style="width: 10%">注册类型</th>
								<th style="width: 10%">实名名称</th>
								<th>注册手机号</th>
								<th>注册邮箱</th>
								<th>实名认证状态</th>
								<th>邀请人</th>
								<th>创建时间</th>
							</tr>
						</thead>
						<tbody id="content">
						</tbody>
					</table>
				</div>
			</fieldset>
			<div class="admin-table-page">
				<div id="paged" class="page">
				</div>
			</div>
		</div>
		<!--模板-->
		<script type="text/html" id="tpl">
			{{# layui.each(d.list, function(index, item){ }}
			<tr>
				<td><input type="radio" style="display: table" name="kycNautralIdRadio" data-id="{{ item.id }}" data-registertype="{{ item.registerType }}"></td>
				<td>{{ convertRegisterType(item.registerType)}}</td>
				<td>{{ item.certificationName }}</td>
				<td>{{ item.phoneNo }}</td>
				<td>{{ item.email }}</td>
				<td>{{ item.certificationStatusDesc }}</td>
				<td>{{ item.inviteCode }}</td>
				<td>{{ item.createTime }}</td>
			</tr>
			{{# }); }}
		</script>
		<script type="text/javascript" src="../../../../plugins/layui/layui.js"></script>
		<script>
			layui.config({
				base: '../../../../js/'
			});
			layui.use(['paging', 'form'], function() {
				var $ = layui.jquery,
					paging = layui.paging(),
					layerTips = parent.layer === undefined ? layui.layer : parent.layer, //获取父窗口的layer对象
					layer = layui.layer, //获取当前窗口的layer对象
					form = layui.form();

                paging.init({
                    openWait: true,
					url: '/api/v1/anon/jsNatural/getKycNaturalList?v=' + new Date().getTime(), //地址
					elem: '#content', //内容容器
					params: {
						certificationStatus:'SUBMIT_FIRST_TRIAL'
					},
					type: 'GET',
					tempElem: '#tpl', //模块容器
					pageConfig: { //分页参数配置
						elem: '#paged', //分页容器
						pageSize: 10 //分页大小
					},
					success: function(a,b,c,d) { //渲染成功的回调
						//alert('渲染成功');
					},
					fail: function(msg) { //获取数据失败的回调
						//alert('获取数据失败')
					},
					complate: function() { //完成的回调
						console.log("加载完成");
					},
				});

				$('#search').on('click', function() {
                    var certificationName = $("#certificationName").val();
                    var phoneNo = $("#phoneNo").val();
                    var certificationStatus = $("#certificationStatus").val();
                    paging.get({
                        "certificationName": certificationName,
                        "phoneNo":phoneNo,
                        "certificationStatus":certificationStatus,
                        "v":new Date().getTime()
                    });
				});

				//反洗钱操作按钮
				$('#fxqBtn').on('click', function() {
					var isChecked = false;
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							isChecked = true;
							var dataId = $cbxDom.getAttribute("data-id");
							if(undefined == dataId || '' == dataId){
								layer.msg('请选中操作行');
								return;
							}
                            infoForm(dataId);
							return;
						}
					});
					if(!isChecked){
						layer.msg('请选中操作行');
					}
				});

				//审核操作按钮
				$('#auditBtn').on('click', function() {
					var isChecked = false;
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							isChecked = true;
							var dataId = $cbxDom.getAttribute("data-id");
							var registerType = $cbxDom.getAttribute('data-registertype');
							if(undefined == dataId || undefined == registerType){
								layer.msg('请选中操作行');
								return;
							}
							auditForm(dataId,registerType,'audit');
							return;
						}
					});
					if(!isChecked){
						layer.msg('请选中操作行');
					}
				});

				//详情操作按钮
				$('#detailBtn').on('click', function() {
					var isChecked = false;
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							isChecked = true;
							var dataId = $cbxDom.getAttribute("data-id");
							var registerType = $cbxDom.getAttribute('data-registertype');
							if(undefined == dataId || undefined == registerType){
								layer.msg('请选中操作行');
								return;
							}
							auditForm(dataId,registerType,'view');
							return;
						}
					});
					if(!isChecked){
						layer.msg('请选中操作行');
					}
				});

				//收费比操作按钮
				$('#kycChargeBtn').on('click', function() {
					var isChecked = false;
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							isChecked = true;
							var dataId = $cbxDom.getAttribute("data-id");
							var registerType = $cbxDom.getAttribute('data-registertype');
							if(undefined == dataId || undefined == registerType){
								layer.msg('请选中操作行');
								return;
							}
							kycChargeForm(dataId,registerType,'audit');
							return;
						}
					});
					if(!isChecked){
						layer.msg('请选中操作行');
					}
				});

				//KYC受益人操作按钮
				$('#kycBeneficiaryBtn').on('click', function() {
					var isChecked = false;
					$('#content').children('tr').each(function() {
						var $that = $(this);
						var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
						var $cbx = $cbxDom.checked;
						if($cbx) {
							isChecked = true;
							var dataId = $cbxDom.getAttribute("data-id");
							if(undefined == dataId || null == dataId || '' == dataId){
								layer.msg('请选中操作行');
								return;
							}
							kycBeneficiaryForm(dataId);
							return;
						}
					});
					if(!isChecked){
						layer.msg('请选中操作行');
					}
				});

                //受益人处理按钮
                $('#failureBeneficiaryProcessBtn').on('click', function() {
                    var isChecked = false;
                    $('#content').children('tr').each(function() {
                        var $that = $(this);
                        var $cbxDom = $that.children('td').eq(0).children('input[type=radio]')[0];
                        var $cbx = $cbxDom.checked;
                        if($cbx) {
                            isChecked = true;
                            var dataId = $cbxDom.getAttribute("data-id");
                            if(undefined == dataId || null == dataId || '' == dataId){
                                layer.msg('请选中操作行');
                                return;
                            }
                            kycFailureBeneficiaryForm(dataId);
                            return;
                        }
                    });
                    if(!isChecked){
                        layer.msg('请选中操作行');
                    }
                });

                function kycFailureBeneficiaryForm(id) {
                    $.get('/api/v1/anon/kycSunrateBeneficiary/failureBeneficiaryProcess.html', null, function(form) {
                        addBoxIndex = layer.open({
                            type: 1,
                            title: '保存商户',
                            content: form,
                            btn: ['保存', '取消'],
                            shade: false,
                            offset: ['100px', '30%'],
                            area: ['600px', '450px'],
                            zIndex: 19950924,
                            maxmin: false,
                            yes: function(index) {
                                //触发表单的提交事件
                                $('form.layui-form').find('button[lay-filter=kycBeneficiaryFailureProcessBtn]').click();
                            },
                            full: function(elem) {
                                var win = window.top === window.self ? window : parent.window;
                                $(win).on('resize', function() {
                                    var $this = $(this);
                                    elem.width($this.width()).height($this.height()).css({
                                        top: 0,
                                        left: 0
                                    });
                                    elem.children('div.layui-layer-content').height($this.height() - 95);
                                });
                            },
                            success: function(layero, index) {
                                //弹出窗口成功后渲染表单
                                var form = layui.form();
                                form.on('submit(kycBeneficiaryFailureProcessBtn)', function(data) {
                                    var btn0 = layero.find(".layui-layer-btn0");
                                    $(btn0).hide();
                                    //这里可以写ajax方法提交表单
                                    $.ajax({
                                        type: "POST",
                                        url: "/api/v1/anon/kycSunrateBeneficiary/addFailureKycSunrateBeneficiary",
                                        data: {
                                            failureMsg : data.field.failureMsg,
                                            kycNaturalId : id
                                        },
                                        success: function(result){
                                            if(result.success == true) {
                                                layerTips.msg('操作成功');
                                                layerTips.close(index);
                                                location.reload(); //刷新
                                            }else {
                                                layerTips.msg(result.msg);
                                                $(btn0).show();
                                            }
                                        }
                                    });
                                    return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
                                });
                            },
                            end: function() {
                                addBoxIndex = -1;
                            }
                        });
                        layer.full(addBoxIndex);
                    });
                }

				function kycBeneficiaryForm(id) {
					$.get('/api/v1/anon/jsNatural/kycBeneficiary.html?id=' + id, null, function(form) {
						addBoxIndex = layer.open({
							type: 1,
							title: 'KYC受益人管理',
							content: form,
							btn: ['提交', '关闭'],
							shadeClose: true,
							offset: ['100px', '30%'],
							area: ['600px', '450px'],
							zIndex: 19950924,
							maxmin: false,
							yes: function(index) {
								//触发表单的提交事件
								$('form.layui-form').find('button[lay-filter=operateKycBeneficiaryBtn]').click();
							},
							full: function(elem) {
								var win = window.top === window.self ? window : parent.window;
								$(win).on('resize', function() {
									var $this = $(this);
									elem.width($this.width()).height($this.height()).css({
										top: 0,
										left: 0
									});
									elem.children('div.layui-layer-content').height($this.height() - 95);
								});
							},
							success: function(layero, index) {
								paging.init({
									openWait: true,
									url: '/api/v1/anon/jsPaySysAcct/getJsPaySysAcctList',
									elem: '#jsPaySysAcctTable', //内容容器
									params: {
										acctType : 'HFGJ_YFJS_BENEFICIARY'
									},
									type: 'GET',
									tempElem: '#jsPaySysAcctTemplate', //模块容器
									success: function(a,b,c,d) { //渲染成功的回调
										//alert('渲染成功');
									},
									fail: function(msg) { //获取数据失败的回调
										//alert('获取数据失败')
									},
									complate: function() { //完成的回调
										paging.init({
											openWait: true,
											url: '/api/v1/anon/kycSunrateBeneficiary/getKycSunrateBeneficiary',
											elem: '#kycSunrateBeneficiaryTable', //内容容器
											params: {
												kycNaturalId : id
											},
											type: 'GET',
											tempElem: '#kycSunrateBeneficiaryTemplate', //模块容器
											success: function(a,b,c,d) { //渲染成功的回调
												//alert('渲染成功');
											},
											fail: function(msg) { //获取数据失败的回调
												//alert('获取数据失败')
											},
											complate: function() { //完成的回调
											},
										});
										//弹出窗口成功后渲染表单
										var form = layui.form();
										$("#kycNaturalId").attr("value",id);
										form.on('submit(operateKycBeneficiaryBtn)', function(data) {
											var jsPaySysAcctId = data.field.jsPaySysAcctId;
											if(null == jsPaySysAcctId || '' == jsPaySysAcctId){
												alert("请选择受益人");
												return false;
											}
											var btn0 = layero.find(".layui-layer-btn0");
											$(btn0).hide();
											$.ajax({
												type: "POST",
												url: "/api/v1/anon/kycSunrateBeneficiary/addKycSunrateBeneficiaryFromSys",
												data: {
													kycNaturalId : id,
													jsPaySysAcctId : jsPaySysAcctId
												},
												success: function(result){
													if(result.success == true) {
														layerTips.msg('操作成功');
														layerTips.close(index);
														location.reload(); //刷新
													}else {
														layerTips.msg(result.msg);
														$(btn0).show();
													}
												}
											});
											return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
										});
										//绑定所有单选按钮事件
										$('#jsPaySysAcctTable').children('tr').each(function() {
											var $that = $(this);
											var $cbxDom = $that.children('td').eq(0).children('input[type=radio]');
											$cbxDom.on('click', function() {
												var dataId = $cbxDom[0].getAttribute("data-id");
												$("#jsPaySysAcctId").attr("value",dataId);
											});
										});
									},
								});
							},
							end: function() {
								addBoxIndex = -1;
							}
						});
						layer.full(addBoxIndex);
					});
				}

				function kycChargeForm(id,registerType) {
					$.get('/api/v1/anon/jsNatural/kycCharge.html?id=' + id + "&registerType=" + registerType, null, function(form) {
						addBoxIndex = layer.open({
							type: 1,
							title: '费率比管理',
							content: form,
							btn: ['提交', '关闭'],
							shadeClose: true,
							offset: ['100px', '30%'],
							area: ['600px', '450px'],
							zIndex: 19950924,
							maxmin: false,
							yes: function(index) {
								//触发表单的提交事件
								$('form.layui-form').find('button[lay-filter=operateKycChargeBtn]').click();
							},
							full: function(elem) {
								var win = window.top === window.self ? window : parent.window;
								$(win).on('resize', function() {
									var $this = $(this);
									elem.width($this.width()).height($this.height()).css({
										top: 0,
										left: 0
									});
									elem.children('div.layui-layer-content').height($this.height() - 95);
								});
							},
							success: function(layero, index) {
								paging.init({
									openWait: true,
									url: '/api/v1/anon/jsNatural/getKycChargeList?kycNaturalId=' + id, //地址
									elem: '#kycChargeTable', //内容容器
									params: {
									},
									type: 'GET',
									tempElem: '#kycChargeTemplate', //模块容器
									success: function(a,b,c,d) { //渲染成功的回调
										//alert('渲染成功');
									},
									fail: function(msg) { //获取数据失败的回调
										//alert('获取数据失败')
									},
									complate: function() { //完成的回调
										//弹出窗口成功后渲染表单
										var form = layui.form();
										form.render('select');
										$("#kycNaturalId").attr("value",id);
										form.on('submit(operateKycChargeBtn)', function(data) {
											var kycNaturalId = data.field.kycNaturalId;
											var kycChargeId = data.field.kycChargeId;
											var chargeType = data.field.chargeType;
											var chargeScale = data.field.chargeScale;
											if(null == chargeScale || '' == chargeScale){
												alert("请填写收费值");
												return false;
											}
											var btn0 = layero.find(".layui-layer-btn0");
											$(btn0).hide();
											$.ajax({
												type: "POST",
												url: "/api/v1/anon/jsNatural/operateKycChargeInfo",
												data: {
													kycNaturalId : kycNaturalId,
													id : kycChargeId,
													chargeType : chargeType,
													chargeScale : chargeScale
												},
												success: function(result){
													if(result.success == true) {
														layerTips.msg('操作成功');
														layerTips.close(index);
														location.reload(); //刷新
													}else {
														layerTips.msg(result.msg);
														$(btn0).show();
													}
												}
											});
											return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
										});
										//绑定所有单选按钮事件
										$('#kycChargeTable').children('tr').each(function() {
											var $that = $(this);
											var $cbxDom = $that.children('td').eq(0).children('input[type=radio]');
											$cbxDom.on('click', function() {
												var dataId = $cbxDom[0].getAttribute("data-id");
												var chargeType = $cbxDom[0].getAttribute("data-charge-type");
												var chargeScale = $cbxDom[0].getAttribute("data-charge-scale");
												console.log(dataId + "-" + chargeType + "-" + chargeScale);

												$("#chargeTypeInput").find("option[value='" + chargeType + "']").attr("selected",true)
												$("#chargeTypeInput").attr("disabled","disabled");
												form.render('select');
												$("#chargeScaleInput").attr("value",chargeScale);
												$("#kycChargeId").attr("value",dataId);
											});
										});
									},
								});
							},
							end: function() {
								addBoxIndex = -1;
							}
						});
						layer.full(addBoxIndex);
					});
				}

                function infoForm(id) {
                    //本表单通过ajax加载 --以模板的形式，当然你也可以直接写在页面上读取
                    $.get('/api/v1/anon/jsNatural/info.html?id=' + id, null, function(form) {
                        addBoxIndex = layer.open({
                            type: 1,
                            title: '用户详情',
                            content: form,
                            btn: ['审核通过', '审核拒绝'],
                            shade: false,
                            offset: ['100px', '30%'],
                            area: ['600px', '450px'],
                            zIndex: 19950924,
                            maxmin: false,
                            yes: function(index) {
                                //触发表单的提交事件
                                $('form.layui-form').find('button[lay-filter=auditPass]').click();
                            },
                            btn2:function(index){
                                $('form.layui-form').find('button[lay-filter=auditRefuse]').click();
							},
                            full: function(elem) {
                                var win = window.top === window.self ? window : parent.window;
                                $(win).on('resize', function() {
                                    var $this = $(this);
                                    elem.width($this.width()).height($this.height()).css({
                                        top: 0,
                                        left: 0
                                    });
                                    elem.children('div.layui-layer-content').height($this.height() - 95);
                                });
                            },
                            success: function(layero, index) {
                                //弹出窗口成功后渲染表单
                                var form = layui.form();
                                form.render();
                                form.on('submit(auditPass)', function(data) {
									//这里可以写ajax方法提交表单
									$.ajax({
										type: "POST",
										url: "/api/v1/anon/jsNatural/auditPass",
										data: data.field,
										success: function(result){
											if(result.success == true) {
												layerTips.msg('审核通过成功');
												layerTips.close(index);
												location.reload(); //刷新
											}else {
												layerTips.msg(result.msg);
												layerTips.close(index);
												location.reload(); //刷新
											}
										}
									});
                                    // return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
                                });
                                form.on('submit(auditRefuse)', function(data) {
                                    $.ajax({
                                        type: "POST",
                                        url: "/api/v1/anon/jsNatural/auditRefuse",
                                        data: data.field,
                                        success: function(result){
                                            if(result.success == true) {
                                                layerTips.msg('审核拒绝成功');
                                                layerTips.close(index);
                                                location.reload(); //刷新
                                            }else {
                                                layerTips.msg(result.msg);
                                                layerTips.close(index);
                                                location.reload(); //刷新
                                            }
                                        }
                                    });
                                });
                            },
                            end: function() {
                                location.reload(); //刷新
                            }
                        });
                        layer.full(addBoxIndex);
                    });
                }

				function editForm(id) {
                    //本表单通过ajax加载 --以模板的形式，当然你也可以直接写在页面上读取
                    $.get('/api/v1/anon/jsNatural/edit.html?id=' + id, null, function(form) {
                        addBoxIndex = layer.open({
                            type: 1,
                            title: '保存商户',
                            content: form,
                            btn: ['保存', '取消'],
                            shade: false,
                            offset: ['100px', '30%'],
                            area: ['600px', '450px'],
                            zIndex: 19950924,
                            maxmin: false,
                            yes: function(index) {
                                //触发表单的提交事件
                                $('form.layui-form').find('button[lay-filter=edit]').click();
                            },
                            full: function(elem) {
                                var win = window.top === window.self ? window : parent.window;
                                $(win).on('resize', function() {
                                    var $this = $(this);
                                    elem.width($this.width()).height($this.height()).css({
                                        top: 0,
                                        left: 0
                                    });
                                    elem.children('div.layui-layer-content').height($this.height() - 95);
                                });
                            },
                            success: function(layero, index) {
                                //弹出窗口成功后渲染表单
                                var form = layui.form();
                                form.render();
                                form.on('submit(edit)', function(data) {
                                    //这里可以写ajax方法提交表单
                                    $.ajax({
                                        type: "POST",
                                        url: "/api/v1/anon/jsNatural/save",
                                        data: data.field,
                                        success: function(result){
                                            if(result.success == true) {
                                                layerTips.msg('保存成功');
                                                layerTips.close(index);
                                                location.reload(); //刷新
                                            }else {
                                                layerTips.msg('保存失败');
                                                layerTips.close(index);
                                                location.reload(); //刷新
                                            }
                                        }
                                    });
                                    return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
                                });
                            },
                            end: function() {
                                addBoxIndex = -1;
                            }
                        });
                        layer.full(addBoxIndex);
                    });
				}

				function auditForm(id,registerType,operateType) {
					//本表单通过ajax加载 --以模板的形式，当然你也可以直接写在页面上读取
					$.get('/api/v1/anon/jsNatural/audit.html?id=' + id + "&registerType=" + registerType + "&operateType=" + operateType, null, function(form) {
						addBoxIndex = layer.open({
							type: 1,
							title: '保存商户',
							content: form,
							btn: ['提交', '关闭'],
							shadeClose: true,
							offset: ['100px', '30%'],
							area: ['600px', '450px'],
							zIndex: 19950924,
							maxmin: false,
							yes: function(index) {
								//触发表单的提交事件
								$('form.layui-form').find('button[lay-filter=audit]').click();
							},
							full: function(elem) {
								var win = window.top === window.self ? window : parent.window;
								$(win).on('resize', function() {
									var $this = $(this);
									elem.width($this.width()).height($this.height()).css({
										top: 0,
										left: 0
									});
									elem.children('div.layui-layer-content').height($this.height() - 95);
								});
							},
							success: function(layero, index) {
								if('view' == operateType){
									var btn0 = layero.find(".layui-layer-btn0");
									$(btn0).hide();
								}
								//弹出窗口成功后渲染表单
								var form = layui.form();
								form.render('select');
								form.on('submit(audit)', function(data) {
									var certiStatus = data.field.certiStatus;
									if(null == certiStatus || '' == certiStatus){
										alert("填写选择审核结果");
										return false;
									}
									var jsRemark = data.field.jsRemark;
									if(('FIRST_TRIAL_FAILURE' == certiStatus || 'CONTACTS_AUDIT_FAILURE' == certiStatus) && (null == jsRemark || '' == jsRemark)){
										alert("驳回请填写驳回原因!");
										return false;
									}
									var btn0 = layero.find(".layui-layer-btn0");
									$(btn0).hide();
									$.ajax({
										type: "POST",
										url: "/api/v1/anon/jsNatural/updateAuditInfo",
										data: {
											jsRemark : jsRemark,
											id : data.field.kycNaturalId,
											registerType : data.field.registerType,
											certificationStatus : certiStatus
										},
										success: function(result){
											if(result.success == true) {
												layerTips.msg('保存成功');
												layerTips.close(index);
												location.reload(); //刷新
											}else {
												layerTips.msg(result.msg);
												$(btn0).show();
											}
										}
									});
									return false; //阻止表单跳转。如果需要表单跳转，去掉这段即可。
								});
							},
							end: function() {
								addBoxIndex = -1;
							}
						});
						layer.full(addBoxIndex);
					});
				}

				function deleteForm(id) {
					layer.confirm(
							'你确认要删除吗？（删除后将不可恢复）',
							{icon: 0, title: '提示'},
							function (index) {
								$.get('/api/v1/anon/jsNatural/delete?id=' + id, null, function (result) {
									if (result.success == true) {
										layerTips.msg('删除成功');
										layerTips.close(index);
										location.reload(); //刷新
									} else {
										layerTips.msg('删除失败');
										layerTips.close(index);
										location.reload(); //刷新
									}
								})
							}, function (index) {
								layer.close(index);
							});
				}
			});
			function convertRegisterType(registerType) {
				if ("NONE_TYPE" == registerType) {
					return "暂无类型";
				} else if ("MAINLAND_PERSONAL" == registerType) {
					return "中国大陆-个人";
				} else if ("MAINLAND_COMPANY" == registerType) {
					return "中国大陆-企业";
				} else if ("HK_PERSONAL" == registerType) {
					return "中国香港-个人";
				} else if ("HK_COMPANY" == registerType) {
					return "中国香港-企业";
				} else {
					return "系统数据异常"
				}
			}

			function previewImg(objSrc) {
				var img = new Image();
				img.src = objSrc;
				var imgHtml = "<img src='" + objSrc + "' />";
				//捕获页
				layer.open({
					type: 1,
					shadeClose:true,
					title: false, //不显示标题
					area:['auto','auto'],
					zIndex: layer.zIndex,
					// area: [height +'px', width +'px'],
					content: imgHtml //捕获的元素，注意：最好该指定的元素要存放在body最外层，否则可能被其它的相对元素所影响
				});
			}
		</script>
	</body>
</html>