package com.js.manage.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.js.api.jspay.service.ApiJsPaySunrateBankTradeInService;
import com.js.api.jspay.service.ApiKycNaturalService;
import com.js.common.constant.Constant;
import com.js.common.enums.ResultEnum;
import com.js.common.model.req.JsTradeListReq;
import com.js.common.model.req.KycNaturalListReq;
import com.js.common.model.req.KycNaturalReq;
import com.js.common.model.vo.KycNaturalVO;
import com.js.common.model.vo.common.ResponseMessage;
import com.js.common.util.ResultUtil;
import com.js.manage.service.JsKycNaturalService;
import com.js.manage.service.JsPayTradeService;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.stereotype.Service;

@Service
public class JsPayTradeServiceImpl implements JsPayTradeService {

    @Reference(
            version = Constant.DUBBO_VERSION,
            application = "${dubbo.application.id}",
            registry = "${dubbo.registry.id}"
    )
    ApiJsPaySunrateBankTradeInService apiJsPaySunrateBankTradeInService;

    @Override
    public String getPayTradeInList(JsTradeListReq jsTradeListReq) {
        return apiJsPaySunrateBankTradeInService.manageTradeInList(jsTradeListReq);
    }

//    @Override
//    public ResponseMessage getKycNatural(String id) {
//        KycNaturalVO kycNaturalVO = apiKycNaturalService.getKycNaturaById(id);
//        if (ObjectUtil.isNotEmpty(kycNaturalVO)) {
//            return ResultUtil.success(kycNaturalVO, ResultEnum.QUERY_SUCCESS);
//        } else {
//            return ResultUtil.error(ResultEnum.QUERY_ERROR);
//        }
//    }
//
//    @Override
//    public int updateKycNatural(KycNaturalReq kycNaturalReq) {
//        return apiKycNaturalService.updateKycNatural(kycNaturalReq);
//    }
//
//    @Override
//    public int deleteKycNatural(String id) {
//        return apiKycNaturalService.deleteKycNaturaById(id);
//    }
}
